/*
 * Decompiled with CFR 0.152.
 */
package com.esri.hadoop.hive;

import com.esri.core.geometry.ogc.OGCGeometry;
import com.esri.hadoop.hive.GeometryUtils;
import com.esri.hadoop.hive.LogUtils;
import com.esri.hadoop.hive.ST_Geometry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;

@Description(name="ST_AsGeoJSON", value="_FUNC_(geometry) - return GeoJSON representation of geometry\n", extended="Example:\n  SELECT _FUNC_(ST_Point(1.0, 2.0)) from onerow; -- {\"type\":\"Point\", \"coordinates\":[1.0, 2.0]}\nNote : \n ST_AsGeoJSON outputs the _geometry_ contents but not _crs_.\n ST_AsGeoJSON requires geometry-api-java version 1.1 or later.\n")
public class ST_AsGeoJson
extends ST_Geometry {
    final Text resultText = new Text();
    static final Log LOG = LogFactory.getLog((String)ST_AsGeoJson.class.getName());

    public Text evaluate(BytesWritable geomref) {
        if (geomref == null || geomref.getLength() == 0) {
            LogUtils.Log_ArgumentsNull(LOG);
            return null;
        }
        OGCGeometry ogcGeometry = GeometryUtils.geometryFromEsriShape(geomref);
        if (ogcGeometry == null) {
            LogUtils.Log_ArgumentsNull(LOG);
            return null;
        }
        try {
            String outJson = ogcGeometry.asGeoJson();
            this.resultText.set(outJson);
            return this.resultText;
        }
        catch (Exception e) {
            LogUtils.Log_InternalError(LOG, "ST_AsGeoJSON: " + e);
            return null;
        }
    }
}

