/*
 * Decompiled with CFR 0.152.
 */
package com.esri.hadoop.hive;

import com.esri.core.geometry.ogc.OGCPoint;
import com.esri.hadoop.hive.BinUtils;
import com.esri.hadoop.hive.HiveGeometryOIHelper;
import java.util.EnumSet;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;

@Description(name="ST_Bin", value="_FUNC_(binsize, point) - return bin ID for given point\n")
public class ST_Bin
extends GenericUDF {
    private transient HiveGeometryOIHelper geomHelper;
    private transient boolean binSizeIsConstant;
    private transient PrimitiveObjectInspector oiBinSize;
    private transient BinUtils bins;

    public ObjectInspector initialize(ObjectInspector[] OIs) throws UDFArgumentException {
        if (OIs.length != 2) {
            throw new UDFArgumentException("Function takes exactly 2 arguments");
        }
        if (OIs[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentException("Argument 0 must be a number");
        }
        this.oiBinSize = (PrimitiveObjectInspector)OIs[0];
        if (!EnumSet.of(PrimitiveObjectInspector.PrimitiveCategory.DOUBLE, PrimitiveObjectInspector.PrimitiveCategory.INT, PrimitiveObjectInspector.PrimitiveCategory.LONG, PrimitiveObjectInspector.PrimitiveCategory.SHORT, PrimitiveObjectInspector.PrimitiveCategory.FLOAT).contains(this.oiBinSize.getPrimitiveCategory())) {
            throw new UDFArgumentException("Argument 0 must be a number");
        }
        this.geomHelper = HiveGeometryOIHelper.create(OIs[1], 1);
        this.binSizeIsConstant = ObjectInspectorUtils.isConstantObjectInspector((ObjectInspector)OIs[0]);
        return PrimitiveObjectInspectorFactory.javaLongObjectInspector;
    }

    public Object evaluate(GenericUDF.DeferredObject[] args) throws HiveException {
        OGCPoint point;
        double binSize = PrimitiveObjectInspectorUtils.getDouble((Object)args[0].get(), (PrimitiveObjectInspector)this.oiBinSize);
        if (!this.binSizeIsConstant || this.bins == null) {
            this.bins = new BinUtils(binSize);
        }
        if ((point = this.geomHelper.getPoint(args)) == null) {
            return null;
        }
        return this.bins.getId(point.X(), point.Y());
    }

    public String getDisplayString(String[] args) {
        assert (args.length == 2);
        return String.format("st_bin(%s,%s)", args[0], args[1]);
    }
}

