/*
 * Decompiled with CFR 0.152.
 */
package com.esri.hadoop.hive;

import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.ogc.OGCPoint;
import com.esri.hadoop.hive.BinUtils;
import com.esri.hadoop.hive.GeometryUtils;
import com.esri.hadoop.hive.HiveGeometryOIHelper;
import java.util.EnumSet;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;

@Description(name="ST_BinEnvelope", value="_FUNC_(binsize, point) - return bin envelope for given point\n_FUNC_(binsize, binid) - return bin envelope for given bin ID\n")
public class ST_BinEnvelope
extends GenericUDF {
    private transient boolean binSizeIsConstant;
    private transient PrimitiveObjectInspector oiBinSize;
    private transient BinUtils bins;
    private transient PrimitiveObjectInspector oiBinId;
    private transient HiveGeometryOIHelper binPoint;

    public ObjectInspector initialize(ObjectInspector[] OIs) throws UDFArgumentException {
        if (OIs.length != 2) {
            throw new UDFArgumentException("Function takes exactly 2 arguments");
        }
        if (!this.isPrimitiveNumber(OIs[0])) {
            throw new UDFArgumentException("Argument 0 must be a number");
        }
        this.oiBinSize = (PrimitiveObjectInspector)OIs[0];
        if (this.isPrimitiveNumber(OIs[1])) {
            this.oiBinId = (PrimitiveObjectInspector)OIs[1];
        } else if (HiveGeometryOIHelper.canCreate(OIs[1])) {
            this.binPoint = HiveGeometryOIHelper.create(OIs, 1);
        } else {
            throw new UDFArgumentException("Argument 1 must be a number or valid geometry type");
        }
        return GeometryUtils.geometryTransportObjectInspector;
    }

    private boolean isPrimitiveNumber(ObjectInspector oi) {
        if (oi.getCategory() != ObjectInspector.Category.PRIMITIVE) {
            return false;
        }
        return EnumSet.of(PrimitiveObjectInspector.PrimitiveCategory.DOUBLE, PrimitiveObjectInspector.PrimitiveCategory.INT, PrimitiveObjectInspector.PrimitiveCategory.LONG, PrimitiveObjectInspector.PrimitiveCategory.SHORT, PrimitiveObjectInspector.PrimitiveCategory.FLOAT).contains(((PrimitiveObjectInspector)oi).getPrimitiveCategory());
    }

    public Object evaluate(GenericUDF.DeferredObject[] args) throws HiveException {
        double binSize = PrimitiveObjectInspectorUtils.getDouble((Object)args[0].get(), (PrimitiveObjectInspector)this.oiBinSize);
        if (!this.binSizeIsConstant || this.bins == null) {
            this.bins = new BinUtils(binSize);
        }
        Envelope env = new Envelope();
        if (this.oiBinId != null) {
            if (args[1].get() == null) {
                return null;
            }
            long binId = PrimitiveObjectInspectorUtils.getLong((Object)args[1].get(), (PrimitiveObjectInspector)this.oiBinId);
            this.bins.queryEnvelope(binId, env);
        } else {
            OGCPoint point = this.binPoint.getPoint(args);
            if (point == null) {
                return null;
            }
            this.bins.queryEnvelope(point.X(), point.Y(), env);
        }
        return GeometryUtils.geometryToEsriShapeBytesWritable((Geometry)env, 0, GeometryUtils.OGCType.ST_POLYGON);
    }

    public String getDisplayString(String[] args) {
        assert (args.length == 2);
        return String.format("st_binenvelope(%s,%s)", args[0], args[1]);
    }
}

