/*
 * Decompiled with CFR 0.152.
 */
package com.esri.hadoop.hive;

import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryEngine;
import com.esri.core.geometry.ogc.OGCGeometry;
import com.esri.hadoop.hive.GeometryUtils;
import com.esri.hadoop.hive.LogUtils;
import com.esri.hadoop.hive.ST_GeometryProcessing;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.io.BytesWritable;

@Description(name="ST_ConvexHull", value="_FUNC_(ST_Geometry, ST_Geometry, ...) - returns an ST_Geometry as the convex hull of the supplied ST_Geometries", extended="Example: SELECT ST_AsText(ST_ConvexHull(ST_Point(0, 0), ST_Point(0, 1), ST_Point(1, 1))) FROM onerow;\nMULTIPOLYGON (((0 0, 1 1, 0 1, 0 0)))")
public class ST_ConvexHull
extends ST_GeometryProcessing {
    static final Log LOG = LogFactory.getLog((String)ST_ConvexHull.class.getName());

    public BytesWritable evaluate(BytesWritable ... geomrefs) {
        if (geomrefs == null || geomrefs.length < 1) {
            return null;
        }
        int firstWKID = 0;
        for (int i = 0; i < geomrefs.length; ++i) {
            BytesWritable geomref = geomrefs[i];
            if (geomref == null || geomref.getLength() == 0) {
                LogUtils.Log_ArgumentsNull(LOG);
                return null;
            }
            if (i == 0) {
                firstWKID = GeometryUtils.getWKID(geomref);
                continue;
            }
            if (firstWKID == GeometryUtils.getWKID(geomref)) continue;
            LogUtils.Log_SRIDMismatch(LOG, geomrefs[0], geomref);
            return null;
        }
        Geometry[] geomsToProcess = new Geometry[geomrefs.length];
        for (int i = 0; i < geomrefs.length; ++i) {
            OGCGeometry ogcGeometry = GeometryUtils.geometryFromEsriShape(geomrefs[i]);
            if (ogcGeometry == null) {
                LogUtils.Log_ArgumentsNull(LOG);
                return null;
            }
            geomsToProcess[i] = ogcGeometry.getEsriGeometry();
        }
        try {
            Geometry[] geomResult = GeometryEngine.convexHull((Geometry[])geomsToProcess, (boolean)true);
            if (geomResult.length != 1) {
                return null;
            }
            Geometry merged = geomResult[0];
            GeometryUtils.OGCType inferredType = GeometryUtils.getInferredOGCType(merged);
            return GeometryUtils.geometryToEsriShapeBytesWritable(merged, firstWKID, inferredType);
        }
        catch (Exception e) {
            LogUtils.Log_ExceptionThrown(LOG, "GeometryEngine.convexHull", e);
            return null;
        }
    }
}

