/*
 * Decompiled with CFR 0.152.
 */
package com.esri.hadoop.hive;

import com.esri.core.geometry.ogc.OGCGeometry;
import com.esri.hadoop.hive.GeometryUtils;
import com.esri.hadoop.hive.LogUtils;
import com.esri.hadoop.hive.ST_GeometryProcessing;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.io.BytesWritable;

@Description(name="ST_Difference", value="_FUNC_(ST_Geometry1, ST_Geometry2) - return the difference of ST_Geometry1 - ST_Geometry2", extended="Examples:\n > SELECT ST_AsText(ST_Difference(ST_MultiPoint(1, 1, 1.5, 1.5, 2, 2), ST_Point(1.5, 1.5))) FROM onerow; \n MULTIPOINT (1 1, 2 2)\n > SELECT ST_AsText(ST_Difference(ST_Polygon(0, 0, 0, 10, 10, 10, 10, 0), ST_Polygon(0, 0, 0, 5, 5, 5, 5, 0))) from onerow;\n MULTIPOLYGON (((10 0, 10 10, 0 10, 0 5, 5 5, 5 0, 10 0)))\n\n")
public class ST_Difference
extends ST_GeometryProcessing {
    static final Log LOG = LogFactory.getLog((String)ST_Difference.class.getName());

    public BytesWritable evaluate(BytesWritable geometryref1, BytesWritable geometryref2) {
        if (geometryref1 == null || geometryref2 == null || geometryref1.getLength() == 0 || geometryref2.getLength() == 0) {
            LogUtils.Log_ArgumentsNull(LOG);
            return null;
        }
        if (!GeometryUtils.compareSpatialReferences(geometryref1, geometryref2)) {
            LogUtils.Log_SRIDMismatch(LOG, geometryref1, geometryref2);
            return null;
        }
        OGCGeometry ogcGeom1 = GeometryUtils.geometryFromEsriShape(geometryref1);
        OGCGeometry ogcGeom2 = GeometryUtils.geometryFromEsriShape(geometryref2);
        if (ogcGeom1 == null || ogcGeom2 == null) {
            LogUtils.Log_ArgumentsNull(LOG);
            return null;
        }
        OGCGeometry diffGeometry = ogcGeom1.difference(ogcGeom2);
        return GeometryUtils.geometryToEsriShapeBytesWritable(diffGeometry);
    }
}

