/*
 * Decompiled with CFR 0.152.
 */
package com.esri.hadoop.hive;

import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.ogc.OGCGeometry;
import com.esri.hadoop.hive.GeometryUtils;
import com.esri.hadoop.hive.LogUtils;
import com.esri.hadoop.hive.ST_GeometryProcessing;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.io.BytesWritable;

@Description(name="ST_Envelope", value="_FUNC_(ST_Geometry) - the envelope of the ST_Geometry", extended="Example:\nSELECT _FUNC_(ST_LineString(0,0, 2,2)) from src LIMIT 1;  -- POLYGON ((0 0, 2 0, 2 2, 0 2, 0 0))\nSELECT _FUNC_(ST_Polygon(2,0, 2,3, 3,0)) from src LIMIT 1;  -- POLYGON ((2 0, 3 0, 3 3, 2 3, 2 0))\nOGC Compliance Notes : \n In the case of a point or a vertical or horizontal line, ST_Envelope may either apply a tolerance or return an empty envelope.")
public class ST_Envelope
extends ST_GeometryProcessing {
    static final Log LOG = LogFactory.getLog((String)ST_Envelope.class.getName());

    public BytesWritable evaluate(BytesWritable geometryref) {
        if (geometryref == null || geometryref.getLength() == 0) {
            LogUtils.Log_ArgumentsNull(LOG);
            return null;
        }
        OGCGeometry ogcGeometry = GeometryUtils.geometryFromEsriShape(geometryref);
        if (ogcGeometry == null) {
            LogUtils.Log_ArgumentsNull(LOG);
            return null;
        }
        int wkid = GeometryUtils.getWKID(geometryref);
        SpatialReference spatialReference = null;
        if (wkid != 0) {
            spatialReference = SpatialReference.create((int)wkid);
        }
        Envelope envBound = new Envelope();
        ogcGeometry.getEsriGeometry().queryEnvelope(envBound);
        return GeometryUtils.geometryToEsriShapeBytesWritable(OGCGeometry.createFromEsriGeometry((Geometry)envBound, (SpatialReference)spatialReference));
    }
}

