/*
 * Decompiled with CFR 0.152.
 */
package com.esri.hadoop.hive;

import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryEngine;
import com.esri.core.geometry.MultiPath;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.ogc.OGCGeometry;
import com.esri.hadoop.hive.GeometryUtils;
import com.esri.hadoop.hive.LogUtils;
import com.esri.hadoop.hive.ST_GeometryAccessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.io.BytesWritable;

@Description(name="ST_GeodesicLengthWGS84", value="_FUNC_(line) - returns distance along line on WGS84 spheroid, in meters, for geographic coordinates", extended="Requires the geometry to be in in WGS84 spatial reference, else returns NULL\nExample:\n SELECT _FUNC_(ST_SetSRID(ST_Linestring(0.0,0.0, 0.3,0.4), 4326)) FROM src LIMIT 1; -- 55km\n SELECT _FUNC_(ST_GeomFromText('MultiLineString((0.0 80.0, 0.3 80.4))', 4326)) FROM src LIMIT 1; -- 45km\n")
public class ST_GeodesicLengthWGS84
extends ST_GeometryAccessor {
    final DoubleWritable resultDouble = new DoubleWritable();
    static final Log LOG = LogFactory.getLog((String)ST_GeodesicLengthWGS84.class.getName());

    public DoubleWritable evaluate(BytesWritable geomref) {
        if (geomref == null || geomref.getLength() == 0) {
            LogUtils.Log_ArgumentsNull(LOG);
            return null;
        }
        int WGS84 = 4326;
        if (GeometryUtils.getWKID(geomref) != WGS84) {
            LogUtils.Log_SRIDMismatch(LOG, geomref, WGS84);
            return null;
        }
        OGCGeometry ogcGeometry = GeometryUtils.geometryFromEsriShape(geomref);
        if (ogcGeometry == null) {
            LogUtils.Log_ArgumentsNull(LOG);
            return null;
        }
        Geometry esriGeom = ogcGeometry.getEsriGeometry();
        switch (esriGeom.getType()) {
            case Point: 
            case MultiPoint: {
                this.resultDouble.set(0.0);
                break;
            }
            default: {
                MultiPath lines = (MultiPath)esriGeom;
                int nPath = lines.getPathCount();
                double length = 0.0;
                for (int ix = 0; ix < nPath; ++ix) {
                    int curPt = lines.getPathStart(ix);
                    int pastPt = lines.getPathEnd(ix);
                    Point fromPt = lines.getPoint(curPt);
                    Point toPt = null;
                    for (int vx = curPt + 1; vx < pastPt; ++vx) {
                        toPt = lines.getPoint(vx);
                        length += GeometryEngine.geodesicDistanceOnWGS84((Point)fromPt, (Point)toPt);
                        fromPt = toPt;
                    }
                }
                this.resultDouble.set(length);
            }
        }
        return this.resultDouble;
    }
}

