/*
 * Decompiled with CFR 0.152.
 */
package com.esri.hadoop.hive;

import com.esri.core.geometry.ogc.OGCGeometry;
import com.esri.hadoop.hive.GeometryUtils;
import com.esri.hadoop.hive.LogUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;

@Description(name="ST_GeomFromGeoJSON", value="_FUNC_(json) - construct an ST_Geometry from GeoJSON", extended="Example:\n  SELECT _FUNC_('{\"type\":\"Point\", \"coordinates\":[1.2, 2.4]}') FROM src LIMIT 1;  -- constructs ST_Point\n  SELECT _FUNC_('{\"type\":\"LineString\", \"coordinates\":[[1,2], [3,4]]}') FROM src LIMIT 1;  -- constructs ST_LineString\n")
public class ST_GeomFromGeoJson
extends GenericUDF {
    static final Log LOG = LogFactory.getLog((String)ST_GeomFromGeoJson.class.getName());
    ObjectInspector jsonOI;

    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        GenericUDF.DeferredObject jsonDeferredObject = arguments[0];
        String json = null;
        if (this.jsonOI.getCategory() != ObjectInspector.Category.STRUCT) {
            PrimitiveObjectInspector primOI = (PrimitiveObjectInspector)this.jsonOI;
            json = (String)primOI.getPrimitiveJavaObject(jsonDeferredObject.get());
        }
        try {
            OGCGeometry ogcGeom = OGCGeometry.fromGeoJson(json);
            return GeometryUtils.geometryToEsriShapeBytesWritable(ogcGeom);
        }
        catch (Exception e) {
            LogUtils.Log_InvalidText(LOG, json);
            return null;
        }
    }

    public String getDisplayString(String[] arg0) {
        return "empty display string";
    }

    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 1) {
            throw new UDFArgumentLengthException("ST_GeomFromJson takes only one argument");
        }
        ObjectInspector argJsonOI = arguments[0];
        if (argJsonOI.getCategory() == ObjectInspector.Category.PRIMITIVE) {
            PrimitiveObjectInspector poi = (PrimitiveObjectInspector)argJsonOI;
            if (poi.getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.STRING) {
                throw new UDFArgumentTypeException(0, "ST_GeomFromJson argument category must be either a string primitive or struct");
            }
        } else if (argJsonOI.getCategory() == ObjectInspector.Category.STRUCT) {
            throw new UDFArgumentTypeException(0, "ST_GeomFromJson argument category must be either a string primitive or struct");
        }
        this.jsonOI = argJsonOI;
        return GeometryUtils.geometryTransportObjectInspector;
    }
}

