/*
 * Decompiled with CFR 0.152.
 */
package com.esri.hadoop.hive;

import com.esri.core.geometry.ogc.OGCGeometry;
import com.esri.hadoop.hive.GeometryUtils;
import java.io.IOException;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParseException;

@Description(name="ST_GeomFromJSON", value="_FUNC_(json) - construct an ST_Geometry from Esri JSON", extended="Example:\n  SELECT _FUNC_('{\"x\":0.0,\"y\":0.0}') FROM src LIMIT 1;  -- constructs ST_Point\n")
public class ST_GeomFromJson
extends GenericUDF {
    static final JsonFactory jsonFactory = new JsonFactory();
    ObjectInspector jsonOI;

    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        GenericUDF.DeferredObject jsonDeferredObject = arguments[0];
        String json = null;
        if (this.jsonOI.getCategory() != ObjectInspector.Category.STRUCT) {
            PrimitiveObjectInspector primOI = (PrimitiveObjectInspector)this.jsonOI;
            json = (String)primOI.getPrimitiveJavaObject(jsonDeferredObject.get());
        }
        try {
            OGCGeometry ogcGeom = OGCGeometry.fromJson(json);
            return GeometryUtils.geometryToEsriShapeBytesWritable(ogcGeom);
        }
        catch (JsonParseException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        return null;
    }

    public String getDisplayString(String[] arg0) {
        return "empty display string";
    }

    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 1) {
            throw new UDFArgumentLengthException("ST_GeomFromJson takes only one argument");
        }
        ObjectInspector argJsonOI = arguments[0];
        if (argJsonOI.getCategory() == ObjectInspector.Category.PRIMITIVE) {
            PrimitiveObjectInspector poi = (PrimitiveObjectInspector)argJsonOI;
            if (poi.getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.STRING) {
                throw new UDFArgumentTypeException(0, "ST_GeomFromJson argument category must be either a string primitive or struct");
            }
        } else if (argJsonOI.getCategory() == ObjectInspector.Category.STRUCT) {
            throw new UDFArgumentTypeException(0, "ST_GeomFromJson argument category must be either a string primitive or struct");
        }
        this.jsonOI = argJsonOI;
        return GeometryUtils.geometryTransportObjectInspector;
    }
}

