/*
 * Decompiled with CFR 0.152.
 */
package com.esri.hadoop.hive;

import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.ogc.OGCGeometry;
import com.esri.hadoop.hive.GeometryUtils;
import com.esri.hadoop.hive.LogUtils;
import com.esri.hadoop.hive.ST_Geometry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;

@Description(name="ST_GeomFromText", value="_FUNC_(wkt) - construct an ST_Geometry from OGC well-known text", extended="Example:\n  SELECT _FUNC_('linestring (1 0, 2 3)') FROM src LIMIT 1;  -- constructs ST_Linestring\n  SELECT _FUNC_('multipoint ((1 0), (2 3))') FROM src LIMIT 1;  -- constructs ST_MultiPoint\n")
public class ST_GeomFromText
extends ST_Geometry {
    static final Log LOG = LogFactory.getLog((String)ST_GeomFromText.class.getName());

    public BytesWritable evaluate(Text wkt) throws UDFArgumentException {
        return this.evaluate(wkt, 0);
    }

    public BytesWritable evaluate(Text wkwrap, int wkid) throws UDFArgumentException {
        String wkt = wkwrap.toString();
        try {
            SpatialReference spatialReference = null;
            if (wkid != 0) {
                spatialReference = SpatialReference.create((int)wkid);
            }
            OGCGeometry ogcObj = OGCGeometry.fromText((String)wkt);
            ogcObj.setSpatialReference(spatialReference);
            return GeometryUtils.geometryToEsriShapeBytesWritable(ogcObj);
        }
        catch (Exception e) {
            LogUtils.Log_InvalidText(LOG, wkt);
            return null;
        }
    }
}

