/*
 * Decompiled with CFR 0.152.
 */
package com.esri.hadoop.hive;

import com.esri.hadoop.hive.GeometryUtils;
import com.esri.hadoop.hive.LogUtils;
import com.esri.hadoop.hive.ST_Geometry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;

@Description(name="ST_GeometryType", value="_FUNC_(geometry) - return type of geometry", extended="Example:\n  > SELECT _FUNC_(ST_Point(1.5, 2.5)) FROM src LIMIT 1;  -- ST_Point\n  > SELECT _FUNC_(ST_LineString(1.5,2.5, 3.0,2.2)) FROM src LIMIT 1;  -- ST_LineString\n  > SELECT _FUNC_(ST_Polygon(2,0, 2,3, 3,0)) FROM src LIMIT 1;  -- ST_Polygon\n")
public class ST_GeometryType
extends ST_Geometry {
    static final Log LOG = LogFactory.getLog((String)ST_GeometryType.class.getName());

    public Text evaluate(BytesWritable ref) {
        if (ref == null || ref.getLength() == 0) {
            LogUtils.Log_ArgumentsNull(LOG);
            return null;
        }
        return new Text(GeometryUtils.getType(ref).toString());
    }
}

