/*
 * Decompiled with CFR 0.152.
 */
package com.esri.hadoop.hive;

import com.esri.core.geometry.ogc.OGCGeometry;
import com.esri.hadoop.hive.GeometryUtils;
import com.esri.hadoop.hive.LogUtils;
import com.esri.hadoop.hive.ST_GeometryAccessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;

@Description(name="ST_Is3D", value="_FUNC_(geometry) - return true if the geometry object is three-dimensional", extended="Example:\n  > SELECT _FUNC_(ST_Polygon(1,1, 1,4, 4,4, 4,1)) FROM src LIMIT 1;  -- false\n  > SELECT _FUNC_(ST_LineString(0.,0., 3.,4., 0.,4., 0.,0.)) FROM src LIMIT 1;  -- false\n  > SELECT _FUNC_(ST_Point(3., 4.)) FROM src LIMIT 1;  -- false\n  > SELECT _FUNC_(ST_PointZ(3., 4., 2)) FROM src LIMIT 1;  -- true\n")
public class ST_Is3D
extends ST_GeometryAccessor {
    final BooleanWritable resultBoolean = new BooleanWritable();
    static final Log LOG = LogFactory.getLog((String)ST_Is3D.class.getName());

    public BooleanWritable evaluate(BytesWritable geomref) {
        if (geomref == null || geomref.getLength() == 0) {
            LogUtils.Log_ArgumentsNull(LOG);
            return null;
        }
        OGCGeometry ogcGeometry = GeometryUtils.geometryFromEsriShape(geomref);
        if (ogcGeometry == null) {
            LogUtils.Log_ArgumentsNull(LOG);
            return null;
        }
        this.resultBoolean.set(ogcGeometry.is3D());
        return this.resultBoolean;
    }
}

