/*
 * Decompiled with CFR 0.152.
 */
package com.esri.hadoop.hive;

import com.esri.core.geometry.ogc.OGCGeometry;
import com.esri.hadoop.hive.GeometryUtils;
import com.esri.hadoop.hive.LogUtils;
import com.esri.hadoop.hive.ST_GeometryAccessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;

@Description(name="ST_IsEmpty", value="_FUNC_(geometry) - return true if the geometry object is empty of geometric information", extended="Example:\n  > SELECT _FUNC_(ST_Point(1.5, 2.5)) FROM src LIMIT 1;  -- false\n  > SELECT _FUNC_(ST_GeomFromText('point empty')) FROM src LIMIT 1;  -- true\n")
public class ST_IsEmpty
extends ST_GeometryAccessor {
    final BooleanWritable resultBoolean = new BooleanWritable();
    static final Log LOG = LogFactory.getLog((String)ST_IsEmpty.class.getName());

    public BooleanWritable evaluate(BytesWritable geomref) {
        if (geomref == null || geomref.getLength() == 0) {
            LogUtils.Log_ArgumentsNull(LOG);
            return null;
        }
        OGCGeometry ogcGeometry = GeometryUtils.geometryFromEsriShape(geomref);
        if (ogcGeometry == null) {
            LogUtils.Log_ArgumentsNull(LOG);
            return null;
        }
        try {
            this.resultBoolean.set(ogcGeometry.isEmpty());
        }
        catch (Exception e) {
            LogUtils.Log_InternalError(LOG, "ST_IsEmpty" + e);
            return null;
        }
        return this.resultBoolean;
    }
}

