/*
 * Decompiled with CFR 0.152.
 */
package com.esri.hadoop.hive;

import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.ogc.OGCGeometry;
import com.esri.hadoop.hive.GeometryUtils;
import com.esri.hadoop.hive.LogUtils;
import com.esri.hadoop.hive.ST_Geometry;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.io.BytesWritable;

@Description(name="ST_MLineFromWKB", value="_FUNC_(wkb) - construct an ST_MultiLineString from OGC well-known binary", extended="Example:\n  SELECT _FUNC_(ST_AsBinary(ST_GeomFromText('multilinestring ((1 0, 2 3), (5 7, 7 5))'))) FROM src LIMIT 1;  -- constructs ST_MultiLineString\n")
public class ST_MLineFromWKB
extends ST_Geometry {
    static final Log LOG = LogFactory.getLog((String)ST_MLineFromWKB.class.getName());

    public BytesWritable evaluate(BytesWritable wkb) throws UDFArgumentException {
        return this.evaluate(wkb, 0);
    }

    public BytesWritable evaluate(BytesWritable wkb, int wkid) throws UDFArgumentException {
        try {
            SpatialReference spatialReference = null;
            if (wkid != 0) {
                spatialReference = SpatialReference.create((int)wkid);
            }
            byte[] byteArr = wkb.getBytes();
            ByteBuffer byteBuf = ByteBuffer.allocate(byteArr.length);
            byteBuf.put(byteArr);
            OGCGeometry ogcObj = OGCGeometry.fromBinary((ByteBuffer)byteBuf);
            ogcObj.setSpatialReference(spatialReference);
            String gType = ogcObj.geometryType();
            if (gType.equals("MultiLineString") || gType.equals("LineString")) {
                return GeometryUtils.geometryToEsriShapeBytesWritable(ogcObj);
            }
            LogUtils.Log_InvalidType(LOG, GeometryUtils.OGCType.ST_MULTILINESTRING, GeometryUtils.OGCType.UNKNOWN);
            return null;
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage());
            return null;
        }
    }
}

