/*
 * Decompiled with CFR 0.152.
 */
package com.esri.hadoop.hive;

import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.ogc.OGCGeometry;
import com.esri.hadoop.hive.GeometryUtils;
import com.esri.hadoop.hive.LogUtils;
import com.esri.hadoop.hive.ST_Geometry;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;

@Description(name="ST_MultiPolygon", value="_FUNC_(array(x1, y1, x2, y2, ... ), array(x1, y1, x2, y2, ... ), ... ) - constructor for 2D multi polygon\n_FUNC_('multipolygon ( ... )') - constructor for 2D multi polygon", extended="Example:\n  SELECT _FUNC_(array(1, 1, 1, 2, 2, 2, 2, 1), array(3, 3, 3, 4, 4, 4, 4, 3)) from src LIMIT 1;\n  SELECT _FUNC_('multipolygon (((0 0, 0 1, 1 0, 0 0)), ((2 2, 2 3, 3 2, 2 2)))') from src LIMIT 1;")
public class ST_MultiPolygon
extends ST_Geometry {
    static final Log LOG = LogFactory.getLog((String)ST_MultiPolygon.class.getName());

    public BytesWritable evaluate(List<DoubleWritable> ... multipaths) throws UDFArgumentLengthException {
        if (multipaths == null || multipaths.length == 0) {
            LogUtils.Log_ArgumentsNull(LOG);
            return null;
        }
        try {
            Polygon mPolygon = new Polygon();
            int arg_idx = 0;
            for (List<DoubleWritable> multipath : multipaths) {
                if (multipath.size() % 2 != 0) {
                    LogUtils.Log_VariableArgumentLengthXY(LOG, arg_idx);
                    return null;
                }
                mPolygon.startPath(multipath.get(0).get(), multipath.get(0).get());
                for (int i = 2; i < multipath.size(); i += 2) {
                    mPolygon.lineTo(multipath.get(i).get(), multipath.get(i + 1).get());
                }
                mPolygon.closeAllPaths();
                ++arg_idx;
            }
            return GeometryUtils.geometryToEsriShapeBytesWritable(OGCGeometry.createFromEsriGeometry((Geometry)mPolygon, null, (boolean)true));
        }
        catch (Exception e) {
            LogUtils.Log_InternalError(LOG, "ST_MultiPolygon: " + e);
            return null;
        }
    }

    public BytesWritable evaluate(Text wkwrap) throws UDFArgumentException {
        String wkt = wkwrap.toString();
        try {
            OGCGeometry ogcObj = OGCGeometry.fromText((String)wkt);
            ogcObj.setSpatialReference(null);
            if (ogcObj.geometryType().equals("MultiPolygon")) {
                return GeometryUtils.geometryToEsriShapeBytesWritable(ogcObj);
            }
            LogUtils.Log_InvalidType(LOG, GeometryUtils.OGCType.ST_MULTIPOLYGON, GeometryUtils.OGCType.UNKNOWN);
            return null;
        }
        catch (Exception e) {
            LogUtils.Log_InvalidText(LOG, wkt);
            return null;
        }
    }
}

