/*
 * Decompiled with CFR 0.152.
 */
package com.esri.hadoop.hive;

import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.ogc.OGCGeometry;
import com.esri.hadoop.hive.GeometryUtils;
import com.esri.hadoop.hive.LogUtils;
import com.esri.hadoop.hive.ST_Geometry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;

@Description(name="ST_Point", value="_FUNC_(x, y) - constructor for 2D point\n_FUNC_('point (x y)') - constructor for 2D point", extended="Example:\n  SELECT _FUNC_(longitude, latitude) from src LIMIT 1;\n  SELECT _FUNC_('point (0 0)') from src LIMIT 1;")
public class ST_Point
extends ST_Geometry {
    static final Log LOG = LogFactory.getLog((String)ST_Point.class.getName());

    public BytesWritable evaluate(DoubleWritable x, DoubleWritable y) {
        return this.evaluate(x, y, null, null);
    }

    public BytesWritable evaluate(DoubleWritable x, DoubleWritable y, DoubleWritable z) {
        return this.evaluate(x, y, z, null);
    }

    public BytesWritable evaluate(DoubleWritable x, DoubleWritable y, DoubleWritable z, DoubleWritable m) {
        if (x == null || y == null) {
            return null;
        }
        try {
            Point stPt = new Point(x.get(), y.get());
            if (z != null) {
                stPt.setZ(z.get());
            }
            if (m != null) {
                stPt.setM(m.get());
            }
            BytesWritable ret = GeometryUtils.geometryToEsriShapeBytesWritable(OGCGeometry.createFromEsriGeometry((Geometry)stPt, null));
            return ret;
        }
        catch (Exception e) {
            return null;
        }
    }

    public BytesWritable evaluate(Text wkwrap) throws UDFArgumentException {
        String wkt = wkwrap.toString();
        try {
            OGCGeometry ogcObj = OGCGeometry.fromText((String)wkt);
            ogcObj.setSpatialReference(null);
            if (ogcObj.geometryType().equals("Point")) {
                return GeometryUtils.geometryToEsriShapeBytesWritable(ogcObj);
            }
            LogUtils.Log_InvalidType(LOG, GeometryUtils.OGCType.ST_POINT, GeometryUtils.OGCType.UNKNOWN);
            return null;
        }
        catch (Exception e) {
            LogUtils.Log_InvalidText(LOG, wkt);
            return null;
        }
    }
}

