/*
 * Decompiled with CFR 0.152.
 */
package com.esri.hadoop.hive;

import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryEngine;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.ogc.OGCGeometry;
import com.esri.hadoop.hive.GeometryUtils;
import com.esri.hadoop.hive.LogUtils;
import com.esri.hadoop.hive.ST_GeometryProcessing;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.io.BytesWritable;

@Description(name="ST_Union", value="_FUNC_(ST_Geometry, ST_Geometry, ...) - returns an ST_Geometry as the union of the supplied ST_Geometries", extended="Example: SELECT ST_AsText(ST_Union(ST_Polygon(1, 1, 1, 4, 4, 4, 4, 1), ST_Polygon(4, 1, 4, 4, 4, 8, 8, 1))) FROM onerow;\nMULTIPOLYGON (((4 1, 8 1, 4 8, 4 4, 1 4, 1 1, 4 1)))")
public class ST_Union
extends ST_GeometryProcessing {
    static final Log LOG = LogFactory.getLog((String)ST_Union.class.getName());

    public BytesWritable evaluate(BytesWritable ... geomrefs) {
        if (geomrefs == null || geomrefs.length < 2) {
            LogUtils.Log_VariableArgumentLength(LOG);
        }
        int firstWKID = 0;
        SpatialReference spatialRef = null;
        for (int i = 0; i < geomrefs.length; ++i) {
            BytesWritable geomref = geomrefs[i];
            if (geomref == null || geomref.getLength() == 0) {
                LogUtils.Log_ArgumentsNull(LOG);
                return null;
            }
            if (i == 0) {
                firstWKID = GeometryUtils.getWKID(geomref);
                if (firstWKID == 0) continue;
                spatialRef = SpatialReference.create((int)firstWKID);
                continue;
            }
            if (firstWKID == GeometryUtils.getWKID(geomref)) continue;
            LogUtils.Log_SRIDMismatch(LOG, geomrefs[0], geomref);
            return null;
        }
        Geometry[] geomsToUnion = new Geometry[geomrefs.length];
        for (int i = 0; i < geomrefs.length; ++i) {
            OGCGeometry ogcGeometry = GeometryUtils.geometryFromEsriShape(geomrefs[i]);
            if (ogcGeometry == null) {
                LogUtils.Log_ArgumentsNull(LOG);
                return null;
            }
            geomsToUnion[i] = ogcGeometry.getEsriGeometry();
        }
        try {
            Geometry unioned = GeometryEngine.union((Geometry[])geomsToUnion, spatialRef);
            GeometryUtils.OGCType inferredType = GeometryUtils.getInferredOGCType(unioned);
            return GeometryUtils.geometryToEsriShapeBytesWritable(unioned, firstWKID, inferredType);
        }
        catch (Exception e) {
            LogUtils.Log_ExceptionThrown(LOG, "GeometryEngine.union", e);
            return null;
        }
    }
}

