/*
 * Decompiled with CFR 0.152.
 */
package com.esri.hadoop.hive;

import com.esri.core.geometry.ogc.OGCGeometry;
import com.esri.core.geometry.ogc.OGCPoint;
import com.esri.hadoop.hive.GeometryUtils;
import com.esri.hadoop.hive.LogUtils;
import com.esri.hadoop.hive.ST_GeometryAccessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.io.BytesWritable;

@Description(name="ST_Y", value="_FUNC_(point) - returns the Y coordinate of point", extended="Example:\n  SELECT _FUNC_(ST_Point(1.5, 2.5)) FROM src LIMIT 1;  --  2.5")
public class ST_Y
extends ST_GeometryAccessor {
    final DoubleWritable resultDouble = new DoubleWritable();
    static final Log LOG = LogFactory.getLog((String)ST_Y.class.getName());

    public DoubleWritable evaluate(BytesWritable geomref) {
        if (geomref == null || geomref.getLength() == 0) {
            LogUtils.Log_ArgumentsNull(LOG);
            return null;
        }
        OGCGeometry ogcGeometry = GeometryUtils.geometryFromEsriShape(geomref);
        if (ogcGeometry == null) {
            return null;
        }
        switch (GeometryUtils.getType(geomref)) {
            case ST_POINT: {
                OGCPoint pt = (OGCPoint)ogcGeometry;
                this.resultDouble.set(pt.Y());
                return this.resultDouble;
            }
        }
        LogUtils.Log_InvalidType(LOG, GeometryUtils.OGCType.ST_POINT, GeometryUtils.getType(geomref));
        return null;
    }
}

