/*
 * Decompiled with CFR 0.152.
 */
package com.esri.hadoop.hive.serde;

import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryEngine;
import com.esri.core.geometry.MapGeometry;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.ogc.OGCGeometry;
import com.esri.hadoop.hive.GeometryUtils;
import com.esri.hadoop.shims.HiveShims;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.lazy.LazyPrimitive;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;

public class JsonSerde
implements SerDe {
    static final Log LOG = LogFactory.getLog((String)JsonSerde.class.getName());
    static JsonFactory jsonFactory = new JsonFactory();
    static String columnNameConstant = null;
    static String columnTypeConstant = null;
    StructObjectInspector rowOI;
    ArrayList<Writable> rowBase;
    ArrayList<Writable> row;
    int numColumns;
    int geometryColumn = -1;
    ArrayList<String> columnNames;
    ArrayList<ObjectInspector> columnOIs;
    boolean[] columnSet;

    public void initialize(Configuration arg0, Properties tbl) throws SerDeException {
        int c;
        this.geometryColumn = -1;
        String columnNameProperty = tbl.getProperty(HiveShims.serdeConstants.LIST_COLUMNS);
        String columnTypeProperty = tbl.getProperty(HiveShims.serdeConstants.LIST_COLUMN_TYPES);
        ArrayList typeInfos = TypeInfoUtils.getTypeInfosFromTypeString((String)columnTypeProperty);
        this.columnNames = new ArrayList();
        this.columnNames.addAll(Arrays.asList(columnNameProperty.toLowerCase().split(",")));
        this.numColumns = this.columnNames.size();
        this.columnOIs = new ArrayList(this.numColumns);
        this.columnSet = new boolean[this.numColumns];
        for (c = 0; c < this.numColumns; ++c) {
            TypeInfo colTypeInfo = (TypeInfo)typeInfos.get(c);
            if (colTypeInfo.getCategory() != ObjectInspector.Category.PRIMITIVE) {
                throw new SerDeException("Only primitive field types are accepted");
            }
            if (colTypeInfo.getTypeName().equals("binary")) {
                if (this.geometryColumn >= 0) {
                    throw new SerDeException("Multiple binary columns defined.  Define only one binary column for geometries");
                }
                this.columnOIs.add((ObjectInspector)GeometryUtils.geometryTransportObjectInspector);
                this.geometryColumn = c;
                continue;
            }
            this.columnOIs.add(TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo((TypeInfo)colTypeInfo));
        }
        this.rowOI = ObjectInspectorFactory.getStandardStructObjectInspector(this.columnNames, this.columnOIs);
        this.rowBase = new ArrayList(this.numColumns);
        this.row = new ArrayList(this.numColumns);
        for (c = 0; c < this.numColumns; ++c) {
            Writable writable;
            PrimitiveObjectInspector poi = (PrimitiveObjectInspector)this.columnOIs.get(c);
            try {
                writable = (Writable)poi.getPrimitiveWritableClass().newInstance();
            }
            catch (InstantiationException e) {
                throw new SerDeException("Error creating Writable from ObjectInspector", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new SerDeException("Error creating Writable from ObjectInspector", (Throwable)e);
            }
            this.rowBase.add(writable);
            this.row.add(null);
        }
    }

    private void setRowFieldFromParser(int fieldIndex, JsonParser parser) throws JsonParseException, IOException {
        PrimitiveObjectInspector poi = (PrimitiveObjectInspector)this.columnOIs.get(fieldIndex);
        this.row.set(fieldIndex, this.rowBase.get(fieldIndex));
        switch (poi.getPrimitiveCategory()) {
            case SHORT: {
                ((ShortWritable)this.row.get(fieldIndex)).set(parser.getShortValue());
                break;
            }
            case INT: {
                ((IntWritable)this.row.get(fieldIndex)).set(parser.getIntValue());
                break;
            }
            case LONG: {
                ((LongWritable)this.row.get(fieldIndex)).set(parser.getLongValue());
                break;
            }
            case DOUBLE: {
                ((DoubleWritable)this.row.get(fieldIndex)).set(parser.getDoubleValue());
                break;
            }
            case FLOAT: {
                ((FloatWritable)this.row.get(fieldIndex)).set(parser.getFloatValue());
                break;
            }
            case BOOLEAN: {
                ((BooleanWritable)this.row.get(fieldIndex)).set(parser.getBooleanValue());
                break;
            }
            case STRING: {
                ((Text)this.row.get(fieldIndex)).set(parser.getText());
                break;
            }
            default: {
                ((Text)this.row.get(fieldIndex)).set(parser.getText());
            }
        }
    }

    private void generateJsonFromValue(Writable value, int fieldIndex, JsonGenerator jsonGen) throws JsonProcessingException, IOException {
        if (value == null) {
            jsonGen.writeObjectField(this.columnNames.get(fieldIndex), null);
            return;
        }
        PrimitiveObjectInspector poi = (PrimitiveObjectInspector)this.columnOIs.get(fieldIndex);
        switch (poi.getPrimitiveCategory()) {
            case SHORT: {
                jsonGen.writeObjectField(this.columnNames.get(fieldIndex), (Object)((ShortWritable)value).get());
                break;
            }
            case INT: {
                jsonGen.writeObjectField(this.columnNames.get(fieldIndex), (Object)((IntWritable)value).get());
                break;
            }
            case LONG: {
                jsonGen.writeObjectField(this.columnNames.get(fieldIndex), (Object)((LongWritable)value).get());
                break;
            }
            case DOUBLE: {
                jsonGen.writeObjectField(this.columnNames.get(fieldIndex), (Object)((DoubleWritable)value).get());
                break;
            }
            case FLOAT: {
                jsonGen.writeObjectField(this.columnNames.get(fieldIndex), (Object)Float.valueOf(((FloatWritable)value).get()));
                break;
            }
            case BOOLEAN: {
                jsonGen.writeObjectField(this.columnNames.get(fieldIndex), (Object)((BooleanWritable)value).get());
                break;
            }
            default: {
                jsonGen.writeObjectField(this.columnNames.get(fieldIndex), (Object)value.toString());
            }
        }
    }

    public Object deserialize(Writable json_in) throws SerDeException {
        Text json = (Text)json_in;
        for (int i = 0; i < this.numColumns; ++i) {
            this.row.set(i, null);
        }
        try {
            JsonParser parser = jsonFactory.createJsonParser(json.toString());
            JsonToken token = parser.nextToken();
            while (token != null) {
                if (token == JsonToken.START_OBJECT) {
                    if (parser.getCurrentName() == "geometry") {
                        if (this.geometryColumn > -1) {
                            MapGeometry mapGeom = GeometryEngine.jsonToGeometry((JsonParser)parser);
                            this.row.set(this.geometryColumn, (Writable)(mapGeom == null ? null : GeometryUtils.geometryToEsriShapeBytesWritable(OGCGeometry.createFromEsriGeometry((Geometry)mapGeom.getGeometry(), (SpatialReference)mapGeom.getSpatialReference()))));
                        } else {
                            parser.skipChildren();
                        }
                    } else if (parser.getCurrentName() == "attributes") {
                        token = parser.nextToken();
                        while (token != JsonToken.END_OBJECT && token != null) {
                            String name = parser.getText().toLowerCase();
                            parser.nextToken();
                            int fieldIndex = this.columnNames.indexOf(name);
                            if (fieldIndex >= 0) {
                                this.setRowFieldFromParser(fieldIndex, parser);
                            }
                            token = parser.nextToken();
                        }
                        token = parser.nextToken();
                    }
                }
                token = parser.nextToken();
            }
        }
        catch (JsonParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.row;
    }

    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.rowOI;
    }

    public SerDeStats getSerDeStats() {
        return null;
    }

    public Class<? extends Writable> getSerializedClass() {
        return Text.class;
    }

    public Writable serialize(Object obj, ObjectInspector oi) throws SerDeException {
        StandardStructObjectInspector structOI = (StandardStructObjectInspector)oi;
        List fieldWritables = structOI.getStructFieldsDataAsList(obj);
        StringWriter writer = new StringWriter();
        try {
            JsonGenerator jsonGen = jsonFactory.createJsonGenerator((Writer)writer);
            jsonGen.writeStartObject();
            jsonGen.writeObjectFieldStart("attributes");
            for (int i = 0; i < fieldWritables.size(); ++i) {
                if (i == this.geometryColumn) continue;
                Object tmpObj = fieldWritables.get(i);
                Writable writable = tmpObj instanceof LazyPrimitive ? ((LazyPrimitive)tmpObj).getWritableObject() : (Writable)tmpObj;
                try {
                    this.generateJsonFromValue(writable, i, jsonGen);
                    continue;
                }
                catch (JsonProcessingException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            jsonGen.writeEndObject();
            if (this.geometryColumn > -1) {
                BytesWritable bytesWritable = (BytesWritable)fieldWritables.get(this.geometryColumn);
                if (bytesWritable == null) {
                    jsonGen.writeObjectField("geometry", null);
                } else {
                    OGCGeometry ogcGeometry = GeometryUtils.geometryFromEsriShape(bytesWritable);
                    jsonGen.writeRaw(",\"geometry\":" + GeometryEngine.geometryToJson((SpatialReference)ogcGeometry.getEsriSpatialReference(), (Geometry)ogcGeometry.getEsriGeometry()));
                }
            }
            jsonGen.writeEndObject();
            jsonGen.close();
        }
        catch (JsonGenerationException e) {
            LOG.error((Object)"Error generating JSON", (Throwable)e);
            return null;
        }
        catch (IOException e) {
            LOG.error((Object)"Error generating JSON", (Throwable)e);
            return null;
        }
        return new Text(writer.toString());
    }
}

