/*
 * Decompiled with CFR 0.152.
 */
package com.ethlo.persistence.tools.eclipselink;

import com.ethlo.persistence.tools.eclipselink.DelegatingPuInfo;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import javax.persistence.spi.PersistenceUnitInfo;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.persistence.jpa.PersistenceProvider;
import org.springframework.orm.jpa.persistenceunit.DefaultPersistenceUnitManager;
import org.springframework.orm.jpa.persistenceunit.SmartPersistenceUnitInfo;
import org.springframework.util.StringUtils;

@Mojo(requiresDependencyResolution=ResolutionScope.COMPILE, defaultPhase=LifecyclePhase.PROCESS_CLASSES, name="ddl", requiresProject=true)
public class EclipselinkDdlGenerationMojo
extends AbstractMojo {
    @Parameter(required=false)
    private String basePackage;
    @Parameter(required=false)
    private String[] basePackages;
    @Parameter(required=true)
    private String databaseProductName;
    @Parameter(required=false)
    private String databaseMajorVersion;
    @Parameter(required=false)
    private String databaseMinorVersion;
    @Parameter(defaultValue="file://${project.build.outputDirectory}/ddl.sql")
    private String ddlTargetFile;
    @Parameter(defaultValue="file://${project.build.outputDirectory}/ddl-drop.sql")
    private String ddlDropTargetFile;
    @Parameter(defaultValue="WARNING", property="logLevel")
    private String logLevel;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(required=false)
    private String action = "drop-and-create";
    @Parameter(defaultValue="false", property="eclipselink.ddl.skip")
    private boolean skip;

    public void execute() throws MojoExecutionException {
        this.setLogLevel(this.logLevel);
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping EclipseLink DDL by request");
        } else {
            Thread thread = Thread.currentThread();
            ClassLoader currentClassLoader = thread.getContextClassLoader();
            try {
                thread.setContextClassLoader(this.getClassLoader());
                this.generateSchema();
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
            finally {
                thread.setContextClassLoader(currentClassLoader);
            }
            this.getLog().info((CharSequence)"Eclipselink DDL completed");
        }
    }

    public void generateSchema() throws MojoFailureException {
        Map<String, Object> cfg = this.buildCfg();
        Object[] allBasePackages = this.getBasePackages();
        this.getLog().info((CharSequence)("Using base packages " + StringUtils.arrayToDelimitedString((Object[])allBasePackages, (String)", ")));
        PersistenceProvider provider = new PersistenceProvider();
        DefaultPersistenceUnitManager manager = new DefaultPersistenceUnitManager();
        manager.setDefaultPersistenceUnitRootLocation(null);
        manager.setDefaultPersistenceUnitName("default");
        manager.setPackagesToScan((String[])allBasePackages);
        String[] zeroPULocations = new String[]{};
        manager.setPersistenceXmlLocations(zeroPULocations);
        manager.afterPropertiesSet();
        SmartPersistenceUnitInfo puInfo = (SmartPersistenceUnitInfo)manager.obtainDefaultPersistenceUnitInfo();
        puInfo.setPersistenceProviderPackageName(provider.getClass().getName());
        this.getLog().info((CharSequence)("Entities found : " + puInfo.getManagedClassNames().size()));
        this.getLog().debug((CharSequence)("Managed class names:\n    * " + StringUtils.collectionToDelimitedString((Collection)puInfo.getManagedClassNames(), (String)"\n    * ")));
        puInfo.getProperties().putAll(cfg);
        provider.generateSchema((PersistenceUnitInfo)new DelegatingPuInfo((PersistenceUnitInfo)puInfo), cfg);
    }

    private Map<String, Object> buildCfg() {
        TreeMap<String, Object> cfg = new TreeMap<String, Object>();
        cfg.put("javax.persistence.schema-generation.database.action", "none");
        cfg.put("javax.persistence.schema-generation.scripts.action", this.action);
        cfg.put("javax.persistence.schema-generation.create-source", "metadata");
        cfg.put("javax.persistence.schema-generation.drop-source", "metadata");
        cfg.put("javax.persistence.schema-generation.scripts.create-target", this.ddlTargetFile);
        cfg.put("javax.persistence.schema-generation.scripts.drop-target", this.ddlDropTargetFile);
        cfg.put("javax.persistence.database-product-name", this.databaseProductName);
        cfg.put("eclipselink.weaving", "false");
        if (this.databaseMajorVersion != null) {
            cfg.put("javax.persistence.database-major-version", this.databaseMajorVersion);
        }
        if (this.databaseMinorVersion != null) {
            cfg.put("javax.persistence.database-minor-version", this.databaseMinorVersion);
        }
        return cfg;
    }

    public void setLogLevel(String logLevel) {
        Level.parse(logLevel);
        this.logLevel = logLevel.toUpperCase();
    }

    private ClassLoader getClassLoader() throws MojoExecutionException {
        try {
            List classpathElements = this.project.getCompileClasspathElements();
            this.getLog().debug((CharSequence)("Classpath URLs: " + StringUtils.collectionToCommaDelimitedString((Collection)classpathElements)));
            ArrayList<URL> projectClasspathList = new ArrayList<URL>();
            for (String element : classpathElements) {
                try {
                    projectClasspathList.add(new File(element).toURI().toURL());
                }
                catch (MalformedURLException e) {
                    throw new MojoExecutionException(element + " is an invalid classpath element", (Exception)e);
                }
            }
            return new URLClassLoader(projectClasspathList.toArray(new URL[0]), Thread.currentThread().getContextClassLoader());
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Dependency resolution failed", (Exception)((Object)e));
        }
    }

    private String[] getBasePackages() throws MojoFailureException {
        ArrayList<String> allBasePackages = new ArrayList<String>();
        if (this.basePackage == null && this.basePackages == null) {
            throw new MojoFailureException("<basePackage> or <basePackages> elements are mandatory");
        }
        if (this.basePackage != null && this.basePackages != null) {
            throw new MojoFailureException("<basePackage> and <basePackages> are mutually exclusive");
        }
        if (this.basePackage != null) {
            allBasePackages.add(this.basePackage);
        }
        if (this.basePackages != null) {
            if (this.basePackages.length == 0) {
                throw new MojoFailureException("No <basePackage> elements specified within <basePackages>");
            }
            allBasePackages.addAll(Arrays.asList(this.basePackages));
        }
        return StringUtils.toStringArray(allBasePackages);
    }
}

