/*
 * Decompiled with CFR 0.152.
 */
package com.ethlo.persistence.tools.eclipselink;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.eclipse.persistence.jpa.PersistenceProvider;
import org.jcp.persistence.ObjectFactory;
import org.jcp.persistence.Persistence;

public class PersistenceXmlHelper {
    static final JAXBContext jc;
    private static final ObjectFactory factory;

    public static Persistence createXml(String name) {
        Persistence persistence = factory.createPersistence();
        Persistence.PersistenceUnit pu = factory.createPersistencePersistenceUnit();
        persistence.getPersistenceUnit().add(pu);
        pu.setName(name);
        pu.setProvider(PersistenceProvider.class.getCanonicalName());
        Persistence.PersistenceUnit.Properties props = factory.createPersistencePersistenceUnitProperties();
        Persistence.PersistenceUnit.Properties.Property prop = factory.createPersistencePersistenceUnitPropertiesProperty();
        prop.setName("eclipselink.weaving");
        prop.setValue("static");
        props.getProperty().add(prop);
        pu.setProperties(props);
        return persistence;
    }

    public static void appendClasses(Persistence doc, Set<String> entityClasses) {
        doc.getPersistenceUnit().get(0).getClazz().addAll(entityClasses);
    }

    public static Persistence parseXml(Path targetFile) {
        try {
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            return (Persistence)unmarshaller.unmarshal(targetFile.toFile());
        }
        catch (JAXBException e) {
            throw new UncheckedIOException("Cannot parse " + targetFile, new IOException(e));
        }
    }

    public static Set<String> getClassesAlreadyDefined(Persistence doc) {
        return doc.getPersistenceUnit().stream().map(Persistence.PersistenceUnit::getClazz).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public static void outputXml(Persistence doc, Path targetFile) {
        try {
            Files.createDirectories(targetFile.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        PersistenceXmlHelper.prettyPrint(doc, targetFile);
    }

    public static void prettyPrint(Persistence document, Path file) {
        try {
            Marshaller marshaller = jc.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal((Object)document, file.toFile());
        }
        catch (JAXBException e) {
            throw new UncheckedIOException("Cannot write " + file, new IOException(e));
        }
    }

    static {
        factory = new ObjectFactory();
        try {
            jc = JAXBContext.newInstance((Class[])new Class[]{Persistence.class});
        }
        catch (JAXBException e) {
            throw new UncheckedIOException(new IOException(e));
        }
    }
}

