/*
 * Decompiled with CFR 0.152.
 */
package com.ethlo.persistence.tools.eclipselink;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.Scanner;
import org.codehaus.plexus.util.StringUtils;
import org.hibernate.jpamodelgen.JPAMetaModelEntityProcessor;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(requiresDependencyResolution=ResolutionScope.COMPILE, defaultPhase=LifecyclePhase.GENERATE_SOURCES, name="modelgen", requiresProject=true)
public class EclipselinkModelGenMojo
extends AbstractMojo {
    public static final String PLUGIN_PREFIX = "JPA modelgen: ";
    public static final String JAVA_FILE_FILTER = "/*.java";
    public static final String[] ALL_JAVA_FILES_FILTER = new String[]{"**/*.java"};
    private final String processor = JPAMetaModelEntityProcessor.class.getName();
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Component
    private BuildContext buildContext;
    @Parameter
    private Set<String> includes = new HashSet<String>();
    @Parameter(defaultValue="${project.build.sourceDirectory}", required=true)
    private File source;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/apt")
    private File generatedSourcesDirectory;
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    private boolean verbose = false;
    private boolean noWarn = false;
    @Parameter(defaultValue="false", property="eclipselink.modelgen.skip")
    private boolean skip;

    private List<File> getCurrentClassPath() {
        ArrayList<File> retVal = new ArrayList<File>();
        URLClassLoader cl = (URLClassLoader)((Object)((Object)this)).getClass().getClassLoader();
        try {
            for (URL url : cl.getURLs()) {
                retVal.add(new File(url.toURI()));
            }
            return retVal;
        }
        catch (URISyntaxException exc) {
            throw new RuntimeException(exc.getMessage(), exc);
        }
    }

    private File[] getClassPathFiles() {
        List classpathElements;
        TreeSet<File> files = new TreeSet<File>(this.getCurrentClassPath());
        try {
            classpathElements = this.project.getTestClasspathElements();
        }
        catch (DependencyResolutionRequiredException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        for (Object o : classpathElements) {
            File file;
            if (o == null || !(file = new File(o.toString())).canRead()) continue;
            files.add(file);
        }
        return files.toArray(new File[0]);
    }

    public void execute() throws MojoExecutionException {
        if (!this.skip) {
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            if (compiler == null) {
                throw new MojoExecutionException("You need to run build with JDK or have tools.jar on the classpath");
            }
            try (StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);){
                Set<File> sourceFiles = this.getSourceFiles();
                if (sourceFiles.isEmpty()) {
                    this.info("No files to process");
                    return;
                }
                this.info("Found " + sourceFiles.size() + " source files for potential processing");
                this.debug("Source files: " + Arrays.toString(sourceFiles.toArray()));
                Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromFiles(sourceFiles);
                Object[] classPathFiles = this.getClassPathFiles();
                String compileClassPath = StringUtils.join((Object[])classPathFiles, (String)File.pathSeparator);
                this.debug("Classpath: " + compileClassPath);
                List<String> compilerOptions = this.buildCompilerOptions(this.processor, compileClassPath);
                this.project.addCompileSourceRoot(this.generatedSourcesDirectory.getAbsolutePath());
                DiagnosticCollector diagnostics = new DiagnosticCollector();
                JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, diagnostics, compilerOptions, null, compilationUnits);
                Boolean retVal = task.call();
                StringBuilder s = new StringBuilder();
                for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
                    s.append("\n").append(diagnostic);
                }
                if (!retVal.booleanValue()) {
                    throw new MojoExecutionException("Processing failed: " + s);
                }
                this.buildContext.refresh(this.generatedSourcesDirectory);
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        }
    }

    private Set<File> getSourceFiles() {
        if (this.source == null || !this.source.exists()) {
            return new TreeSet<File>();
        }
        String[] filters = ALL_JAVA_FILES_FILTER;
        if (this.includes != null && !this.includes.isEmpty()) {
            filters = this.includes.toArray(new String[0]);
            for (int i = 0; i < filters.length; ++i) {
                filters[i] = filters[i].replace('.', '/') + JAVA_FILE_FILTER;
            }
        }
        HashSet<File> files = new HashSet<File>();
        Scanner scanner = this.buildContext.newScanner(this.source);
        scanner.setIncludes(filters);
        scanner.scan();
        String[] includedFiles = scanner.getIncludedFiles();
        if (includedFiles != null) {
            for (String includedFile : includedFiles) {
                files.add(new File(scanner.getBasedir(), includedFile));
            }
        }
        return files;
    }

    private List<String> buildCompilerOptions(String processor, String compileClassPath) {
        LinkedHashMap<String, String> compilerOpts = new LinkedHashMap<String, String>();
        compilerOpts.put("cp", compileClassPath);
        compilerOpts.put("proc:only", null);
        compilerOpts.put("processor", processor);
        if (this.noWarn) {
            compilerOpts.put("nowarn", null);
        }
        if (this.verbose) {
            compilerOpts.put("verbose", null);
        }
        if (!StringUtils.isEmpty((String)this.encoding)) {
            compilerOpts.put("encoding", this.encoding);
        }
        this.info("Output directory: " + this.generatedSourcesDirectory.getAbsolutePath());
        if (!this.generatedSourcesDirectory.exists()) {
            this.generatedSourcesDirectory.mkdirs();
        }
        compilerOpts.put("d", this.generatedSourcesDirectory.getAbsolutePath());
        try {
            compilerOpts.put("sourcepath", this.source.getCanonicalPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        ArrayList<String> opts = new ArrayList<String>(compilerOpts.size() * 2);
        for (Map.Entry compilerOption : compilerOpts.entrySet()) {
            opts.add("-" + (String)compilerOption.getKey());
            String value = (String)compilerOption.getValue();
            if (!StringUtils.isNotBlank((String)value)) continue;
            opts.add(value);
        }
        return opts;
    }

    private void debug(String msg) {
        this.getLog().debug((CharSequence)(PLUGIN_PREFIX + msg));
    }

    private void info(String msg) {
        this.getLog().info((CharSequence)(PLUGIN_PREFIX + msg));
    }
}

