/*
 * Decompiled with CFR 0.152.
 */
package com.ethlo.persistence.tools.eclipselink;

import com.ethlo.persistence.tools.eclipselink.PersistenceXmlHelper;
import com.ethlo.persistence.tools.eclipselink.Utils;
import ee.jakarta.persistence.ObjectFactory;
import ee.jakarta.persistence.Persistence;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import jakarta.persistence.Converter;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Entity;
import jakarta.persistence.MappedSuperclass;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.tools.weaving.jpa.StaticWeaveProcessor;
import org.springframework.util.StringUtils;

@Mojo(requiresDependencyResolution=ResolutionScope.COMPILE, defaultPhase=LifecyclePhase.PROCESS_CLASSES, name="weave", requiresProject=true)
public class EclipselinkStaticWeaveMojo
extends AbstractMojo {
    @Parameter
    private String basePackage;
    @Parameter
    private String[] basePackages;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    private File source;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    private File target;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private File persistenceInfoLocation;
    @Parameter(defaultValue="WARNING", property="logLevel")
    private String logLevel;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="true")
    private boolean addClassesToPersistenceFile;
    @Parameter(defaultValue="true")
    private boolean updatePersistenceXml;
    @Parameter(defaultValue="false", property="eclipselink.weave.skip")
    private boolean skip;

    public void execute() throws MojoExecutionException {
        this.setLogLevel(this.logLevel);
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping EclipseLink weaving by request");
        } else {
            URLClassLoader classLoader = new URLClassLoader(this.getClassPath(), Thread.currentThread().getContextClassLoader());
            try {
                this.processWeaving(classLoader);
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
            this.getLog().info((CharSequence)"Eclipselink weaving completed");
        }
    }

    private void processWeaving(ClassLoader classLoader) throws MojoExecutionException, MojoFailureException {
        if (!this.source.exists()) {
            throw new MojoExecutionException("Source directory " + this.source + " does not exist");
        }
        try {
            Object[] allBasePackages = this.getBasePackages();
            if (allBasePackages.length > 0) {
                this.getLog().info((CharSequence)("Only entities from base packages '" + StringUtils.arrayToDelimitedString((Object[])allBasePackages, (String)", ") + "' will be included in persistence.xml"));
            }
            Object[] classPath = this.getClassPath();
            this.getLog().debug((CharSequence)("Scanning class-path: " + Arrays.toString(classPath)));
            Set<String> entityClasses = this.findEntities((String[])allBasePackages, (URL[])classPath);
            this.getLog().info((CharSequence)("Entities found : " + entityClasses.size()));
            if (this.updatePersistenceXml) {
                this.getLog().debug((CharSequence)"Updating persistence.xml file");
                this.processPersistenceXml(entityClasses);
            } else {
                this.getLog().debug((CharSequence)"Skipping update of persistence.xml file");
            }
            this.getLog().info((CharSequence)("Source classes dir: " + this.source));
            this.getLog().info((CharSequence)("Target classes dir: " + this.target));
            StaticWeaveProcessor weaveProcessor = new StaticWeaveProcessor(this.source, this.target);
            weaveProcessor.setPersistenceInfo(this.persistenceInfoLocation);
            weaveProcessor.setClassLoader(classLoader);
            weaveProcessor.setLog((Writer)new PrintWriter(System.out));
            weaveProcessor.setLogLevel(this.getLogLevel());
            weaveProcessor.performWeaving();
        }
        catch (IOException | URISyntaxException e) {
            throw new MojoExecutionException("Error", e);
        }
    }

    private void processPersistenceXml(Set<String> entityClasses) {
        ObjectFactory objectFactory = new ObjectFactory();
        objectFactory.createPersistence();
        Path targetFile = Paths.get(this.persistenceInfoLocation.getAbsolutePath(), "/META-INF/persistence.xml");
        this.getLog().info((CharSequence)("persistence.xml location: " + targetFile));
        String name = this.project.getArtifactId();
        Persistence doc = Files.exists(targetFile, new LinkOption[0]) ? PersistenceXmlHelper.parseXml(targetFile) : PersistenceXmlHelper.createXml(name);
        this.checkExisting(targetFile, doc, entityClasses);
        if (this.addClassesToPersistenceFile) {
            PersistenceXmlHelper.appendClasses(doc, entityClasses);
        }
        PersistenceXmlHelper.outputXml(doc, targetFile);
    }

    private void checkExisting(Path targetFile, Persistence doc, Set<String> entityClasses) {
        if (Files.exists(targetFile, new LinkOption[0])) {
            Set<String> alreadyDefined = PersistenceXmlHelper.getClassesAlreadyDefined(doc);
            if (!alreadyDefined.containsAll(entityClasses)) {
                TreeSet<String> undefined = new TreeSet<String>();
                for (String className : entityClasses) {
                    if (alreadyDefined.contains(className)) continue;
                    undefined.add(className);
                }
                this.getLog().warn((CharSequence)("The following classes was not defined in " + targetFile + " even though they are available on the class path: " + Arrays.toString(undefined.toArray())));
            }
            entityClasses.removeAll(alreadyDefined);
        }
    }

    private int getLogLevel() {
        return AbstractSessionLog.translateStringToLoggingLevel((String)this.logLevel);
    }

    public void setLogLevel(String logLevel) {
        Level.parse(logLevel);
        this.logLevel = logLevel.toUpperCase();
    }

    private URL[] getClassPath() {
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            for (File file : Utils.getClassPathFiles(this.project)) {
                urls.add(file.toURI().toURL());
            }
            return urls.toArray(new URL[0]);
        }
        catch (MalformedURLException exc) {
            throw new RuntimeException(exc.getMessage(), exc);
        }
    }

    private Set<String> findEntities(String[] allBasePackages, URL[] classPath) {
        TreeSet<String> result = new TreeSet<String>();
        try (ScanResult scanResult = new ClassGraph().acceptPackages(allBasePackages).enableAnnotationInfo().overrideClasspath((Object[])classPath).scan();){
            result.addAll(this.extract(scanResult, Entity.class));
            result.addAll(this.extract(scanResult, MappedSuperclass.class));
            result.addAll(this.extract(scanResult, Embeddable.class));
            result.addAll(this.extract(scanResult, Converter.class));
        }
        return result;
    }

    private Collection<? extends String> extract(ScanResult scanResult, Class<?> type) {
        return scanResult.getClassesWithAnnotation(type.getCanonicalName()).getNames();
    }

    private String[] getBasePackages() throws MojoFailureException {
        ArrayList<String> allBasePackages = new ArrayList<String>();
        if (this.basePackage != null && this.basePackages != null) {
            throw new MojoFailureException("<basePackage> and <basePackages> are mutually exclusive");
        }
        if (this.basePackage != null) {
            allBasePackages.add(this.basePackage);
        } else if (this.basePackages != null) {
            if (this.basePackages.length == 0) {
                throw new MojoFailureException("No <basePackage> elements specified within <basePackages>");
            }
            allBasePackages.addAll(Arrays.asList(this.basePackages));
        }
        return StringUtils.toStringArray(allBasePackages);
    }
}

