/*
 * Decompiled with CFR 0.152.
 */
package com.ethlo.ascii;

import com.ethlo.ascii.AnsiColor;
import com.ethlo.ascii.SeparatorRow;
import com.ethlo.ascii.TableCell;
import com.ethlo.ascii.TableRow;
import com.ethlo.ascii.TableTheme;
import com.ethlo.util.StringUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Table {
    private static final String NEWLINE = System.lineSeparator();
    private final List<TableRow> rows;
    private final Map<Integer, Integer> minColumnWidths;
    private final int tableWidth;
    private final TableTheme theme;

    public Table(TableTheme theme, List<TableRow> rows) {
        this.theme = theme;
        this.rows = rows;
        Map<Integer, Boolean> hasContent = this.getHasColumnContent(rows);
        this.minColumnWidths = Table.getMaxContentLengths(rows, hasContent);
        this.tableWidth = this.calculateTotalWidth(this.minColumnWidths);
    }

    private static Map<Integer, Integer> getMaxContentLengths(List<TableRow> rows, Map<Integer, Boolean> hasContent) {
        HashMap<Integer, Integer> maxLengths = new HashMap<Integer, Integer>();
        for (TableRow row : rows) {
            for (int i = 0; i < row.getCells().size(); ++i) {
                maxLengths.compute(i, (key, value) -> {
                    int cellLength = row.getCells().get((int)key).getValue().length();
                    return value != null ? Math.max(value, cellLength) : cellLength;
                });
            }
        }
        hasContent.entrySet().stream().filter(e -> (Boolean)e.getValue() == false).forEach(e -> {
            Integer cfr_ignored_0 = (Integer)maxLengths.remove(e.getKey());
        });
        return maxLengths;
    }

    private Map<Integer, Boolean> getHasColumnContent(List<TableRow> rows) {
        HashMap<Integer, Boolean> result = new HashMap<Integer, Boolean>();
        for (TableRow row : rows) {
            for (int i = 0; i < row.getCells().size(); ++i) {
                result.compute(i, (key, value) -> row.getCells().get((int)key).getValue().length() > 0);
            }
        }
        return result;
    }

    private int calculateTotalWidth(Map<Integer, Integer> maxLengths) {
        int paddingSpace = maxLengths.size() * 2 * this.theme.getPadding().length();
        int barSpace = (maxLengths.size() + 1) * this.theme.getVerticalSeparator().length();
        int cellSpace = maxLengths.values().stream().reduce(0, Integer::sum);
        return cellSpace + paddingSpace + barSpace;
    }

    public String render(String title) {
        String titleRow = title != null ? this.theme.getCellBackground().value() + this.theme.getStringColor().value() + StringUtil.adjustPadRight(this.theme.getPadding() + title, this.tableWidth) + AnsiColor.RESET.value() : "";
        return NEWLINE + titleRow + NEWLINE + this.theme.getCellBackground().value() + this.toString(this.rows);
    }

    private String toString(List<TableRow> rows) {
        StringBuilder sb = new StringBuilder();
        boolean hasVerticalSeparator = this.theme.getVerticalSeparator().length() != 0;
        for (int rowIndex = 0; rowIndex < rows.size(); ++rowIndex) {
            TableRow row = rows.get(rowIndex);
            if (row instanceof SeparatorRow) {
                if (!hasVerticalSeparator) continue;
                for (Map.Entry<Integer, Integer> entry : this.minColumnWidths.entrySet()) {
                    sb.append(this.theme.getVerticalSpacerColor().value()).append(this.theme.getCellBackground().value());
                    sb.append(this.getCellStart(entry.getKey(), rowIndex));
                    int width = entry.getValue() + 2 * this.theme.getPadding().length();
                    sb.append(StringUtil.repeat(this.verticalSep(), width));
                }
                sb.append(this.theme.getVerticalSpacerColor().value()).append(this.theme.getCellBackground().value());
                sb.append(this.getCellEnd(rowIndex)).append(AnsiColor.RESET.value()).append(NEWLINE);
                continue;
            }
            sb.append(this.toString(row)).append(NEWLINE);
        }
        return sb.toString();
    }

    private String getCellEnd(int rowIndex) {
        if (rowIndex == 0) {
            return this.theme.getRightTop();
        }
        if (rowIndex == this.rows.size() - 1) {
            return this.theme.getRightBottom();
        }
        return this.theme.getRightCross();
    }

    private String getCellStart(Integer columnIndex, int rowIndex) {
        boolean lastRow;
        boolean lastColumn = columnIndex.intValue() == this.minColumnWidths.size();
        boolean firstColumn = columnIndex == 0;
        boolean firstRow = rowIndex == 0;
        boolean bl = lastRow = rowIndex == this.rows.size() - 1;
        if (firstColumn && firstRow) {
            return this.theme.getLeftTop();
        }
        if (firstColumn && lastRow) {
            return this.theme.getLeftBottom();
        }
        if (firstColumn) {
            return this.theme.getLeftCross();
        }
        if (firstRow) {
            return this.theme.getTopCross();
        }
        if (lastRow) {
            return this.theme.getBottomCross();
        }
        return this.theme.getCross();
    }

    private String toString(TableRow row) {
        int totalColumns = this.minColumnWidths.size();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Integer, Integer> entry : this.minColumnWidths.entrySet()) {
            int colIndex = entry.getKey();
            Integer minWidth = this.minColumnWidths.get(colIndex);
            if (colIndex < row.getCells().size()) {
                TableCell cell = row.getCells().get(colIndex);
                sb.append(cell.render(this.theme, minWidth));
                continue;
            }
            sb.append(new TableCell(" ").render(this.theme, minWidth));
        }
        return sb.append(this.horisontalSep()).toString();
    }

    private String horisontalSep() {
        return TableCell.color(this.theme.getHorizontalSeparator(), this.theme.getHorizontalSpacerColor(), this.theme.getCellBackground());
    }

    private String verticalSep() {
        return TableCell.color(this.theme.getVerticalSeparator(), this.theme.getVerticalSpacerColor(), this.theme.getCellBackground());
    }
}

