/*
 * Decompiled with CFR 0.152.
 */
package com.ethlo.ascii;

import com.ethlo.ascii.AnsiBackgroundColor;
import com.ethlo.ascii.AnsiColor;
import com.ethlo.ascii.TableTheme;
import com.ethlo.util.StringUtil;

public class TableCell {
    private final String value;
    private final boolean left;
    private final boolean isNumeric;

    public TableCell(String value) {
        this(value, true, false);
    }

    public TableCell(String value, boolean left, boolean isNumeric) {
        this.value = value;
        this.left = left;
        this.isNumeric = isNumeric;
    }

    public static String color(String value, AnsiColor color, AnsiBackgroundColor backgroundColor) {
        return color.value() + backgroundColor.value() + value + AnsiColor.RESET.value();
    }

    public String getValue() {
        return this.value;
    }

    public String render(TableTheme theme, int minWidth) {
        String paddedValue = this.left ? StringUtil.adjustPadRight(this.value, minWidth) : StringUtil.adjustPadLeft(this.value, minWidth);
        return TableCell.color(theme.getHorizontalSeparator() + theme.getPadding(), theme.getHorizontalSpacerColor(), theme.getCellBackground()) + TableCell.color(paddedValue, this.isNumeric ? theme.getNumericColor() : theme.getStringColor(), theme.getCellBackground()) + this.padding(theme);
    }

    private String padding(TableTheme theme) {
        return TableCell.color(theme.getPadding(), theme.getStringColor(), theme.getCellBackground());
    }
}

