/*
 * Decompiled with CFR 0.152.
 */
package com.ethlo.ascii;

import com.ethlo.ascii.AnsiBackgroundColor;
import com.ethlo.ascii.AnsiColor;

public class TableTheme {
    public static final TableTheme DEFAULT = TableTheme.builder().build();
    public static final TableTheme TSV = TableTheme.builder().leftTop("").rightTop("").bottomCross("").topCross("").rightBottom("").leftBottom("").verticalSeparator("").horizontalSeparator("\t").build();
    public static final TableTheme DOUBLE = TableTheme.builder().cross("\u256c").rightCross("\u2563").leftCross("\u2560").topCross("\u2566").bottomCross("\u2569").leftTop("\u2554").rightTop("\u2557").leftBottom("\u255a").rightBottom("\u255d").verticalSeparator("\u2550").horizontalSeparator("\u2551").build();
    public static final TableTheme ROUNDED = DEFAULT.begin().leftTop("\u256d").rightTop("\u256e").leftBottom("\u2570").rightBottom("\u256f").build();
    public static final TableTheme RED_HERRING = TableTheme.builder().stringColor(AnsiColor.BRIGHT_WHITE).numericColor(AnsiColor.GREEN).verticalSpacerColor(AnsiColor.RED).horizontalSpacerColor(AnsiColor.RED).cellBackground(AnsiBackgroundColor.BLACK).build();
    public static final TableTheme MINIMAL = TableTheme.builder().stringColor(AnsiColor.GRAY).numericColor(AnsiColor.GREEN).horizontalSeparator(" ").verticalSpacerColor(AnsiColor.GRAY).horizontalSpacerColor(AnsiColor.GRAY).cellBackground(AnsiBackgroundColor.BLACK).build();
    public static final TableTheme COMPACT = TableTheme.builder().verticalSeparator("").horizontalSeparator("").padding(" ").build();
    private final AnsiColor stringColor;
    private final AnsiColor numericColor;
    private final AnsiColor horizontalSpacerColor;
    private final AnsiColor verticalSpacerColor;
    private final AnsiBackgroundColor cellBackground;
    private final String horizontalSeparator;
    private final String verticalSeparator;
    private final String padding;
    private final String cross;
    private final String leftCross;
    private final String rightCross;
    private final String leftTop;
    private final String rightTop;
    private final String leftBottom;
    private final String rightBottom;
    private final String topCross;
    private final String bottomCross;

    private TableTheme(Builder builder) {
        this.stringColor = builder.stringColor;
        this.numericColor = builder.numericColor;
        this.horizontalSpacerColor = builder.horizontalSpacerColor;
        this.verticalSpacerColor = builder.verticalSpacerColor;
        this.cellBackground = builder.cellBackground;
        this.horizontalSeparator = builder.horizontalSeparator;
        this.verticalSeparator = builder.verticalSeparator;
        this.padding = builder.padding;
        this.cross = builder.cross;
        this.topCross = builder.topCross;
        this.bottomCross = builder.bottomCross;
        this.leftCross = builder.leftCross;
        this.rightCross = builder.rightCross;
        this.leftTop = builder.leftTop;
        this.rightTop = builder.rightTop;
        this.leftBottom = builder.leftBottom;
        this.rightBottom = builder.rightBottom;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder begin() {
        Builder builder = new Builder();
        builder.stringColor = this.stringColor;
        builder.numericColor = this.numericColor;
        builder.horizontalSpacerColor = this.horizontalSpacerColor;
        builder.verticalSpacerColor = this.verticalSpacerColor;
        builder.cellBackground = this.cellBackground;
        builder.horizontalSeparator = this.horizontalSeparator;
        builder.verticalSeparator = this.verticalSeparator;
        builder.padding = this.padding;
        builder.cross = this.cross;
        builder.topCross = this.topCross;
        builder.bottomCross = this.bottomCross;
        builder.leftCross = this.leftCross;
        builder.rightCross = this.rightCross;
        builder.leftTop = this.leftTop;
        builder.rightTop = this.rightTop;
        builder.leftBottom = this.leftBottom;
        builder.rightBottom = this.rightBottom;
        return builder;
    }

    public AnsiColor getStringColor() {
        return this.stringColor;
    }

    public AnsiColor getNumericColor() {
        return this.numericColor;
    }

    public AnsiColor getHorizontalSpacerColor() {
        return this.horizontalSpacerColor;
    }

    public AnsiColor getVerticalSpacerColor() {
        return this.verticalSpacerColor;
    }

    public AnsiBackgroundColor getCellBackground() {
        return this.cellBackground;
    }

    public String getHorizontalSeparator() {
        return this.horizontalSeparator;
    }

    public String getVerticalSeparator() {
        return this.verticalSeparator;
    }

    public String getPadding() {
        return this.padding;
    }

    public String getCross() {
        return this.cross;
    }

    public String getLeftCross() {
        return this.leftCross;
    }

    public String getRightCross() {
        return this.rightCross;
    }

    public String getTopCross() {
        return this.topCross;
    }

    public String getBottomCross() {
        return this.bottomCross;
    }

    public String getLeftTop() {
        return this.leftTop;
    }

    public String getRightTop() {
        return this.rightTop;
    }

    public String getLeftBottom() {
        return this.leftBottom;
    }

    public String getRightBottom() {
        return this.rightBottom;
    }

    public static final class Builder {
        public String topCross = "\u252c";
        public String bottomCross = "\u2534";
        private AnsiColor stringColor = AnsiColor.NONE;
        private AnsiColor numericColor = AnsiColor.NONE;
        private AnsiColor horizontalSpacerColor = AnsiColor.NONE;
        private AnsiColor verticalSpacerColor = AnsiColor.NONE;
        private AnsiBackgroundColor cellBackground = AnsiBackgroundColor.NONE;
        private String horizontalSeparator = "\u2502";
        private String verticalSeparator = "\u2500";
        private String padding = " ";
        private String cross = "\u253c";
        private String leftCross = "\u251c";
        private String rightCross = "\u2524";
        private String leftTop = "\u250c";
        private String rightTop = "\u2510";
        private String leftBottom = "\u2514";
        private String rightBottom = "\u2518";

        private Builder() {
        }

        public Builder stringColor(AnsiColor stringColor) {
            this.stringColor = stringColor;
            return this;
        }

        public Builder numericColor(AnsiColor numericColor) {
            this.numericColor = numericColor;
            return this;
        }

        public Builder horizontalSpacerColor(AnsiColor horizontalSpacerColor) {
            this.horizontalSpacerColor = horizontalSpacerColor;
            return this;
        }

        public Builder verticalSpacerColor(AnsiColor verticalSpacerColor) {
            this.verticalSpacerColor = verticalSpacerColor;
            return this;
        }

        public Builder cellBackground(AnsiBackgroundColor cellBackground) {
            this.cellBackground = cellBackground;
            return this;
        }

        public Builder horizontalSeparator(String horizontalSeparator) {
            this.horizontalSeparator = horizontalSeparator;
            return this;
        }

        public Builder verticalSeparator(String verticalSeparator) {
            this.verticalSeparator = verticalSeparator;
            return this;
        }

        public Builder padding(String padding) {
            this.padding = padding;
            return this;
        }

        public Builder cross(String cross) {
            this.cross = cross;
            return this;
        }

        public Builder leftCross(String leftCross) {
            this.leftCross = leftCross;
            return this;
        }

        public Builder rightCross(String rightCross) {
            this.rightCross = rightCross;
            return this;
        }

        public Builder topCross(String topCross) {
            this.topCross = topCross;
            return this;
        }

        public Builder bottomCross(String bottomCross) {
            this.bottomCross = bottomCross;
            return this;
        }

        public Builder leftTop(String leftTop) {
            this.leftTop = leftTop;
            return this;
        }

        public Builder rightTop(String rightTop) {
            this.rightTop = rightTop;
            return this;
        }

        public Builder leftBottom(String leftBottom) {
            this.leftBottom = leftBottom;
            return this;
        }

        public Builder rightBottom(String rightBottom) {
            this.rightBottom = rightBottom;
            return this;
        }

        public TableTheme build() {
            return new TableTheme(this);
        }
    }
}

