/*
 * Decompiled with CFR 0.152.
 */
package com.ethlo.time;

import java.time.Duration;

public class CaptureConfig {
    public static final CaptureConfig DEFAULT = CaptureConfig.minInterval(Duration.ZERO);
    private final Duration sampleRate;

    private CaptureConfig(Builder builder) {
        this.sampleRate = builder.minInterval;
    }

    public static CaptureConfig minInterval(Duration minInterval) {
        return CaptureConfig.builder().minInterval(minInterval).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Duration getMinInterval() {
        return this.sampleRate;
    }

    public static final class Builder {
        private Duration minInterval;

        private Builder() {
        }

        public Builder minInterval(Duration minInterval) {
            this.minInterval = minInterval;
            return this;
        }

        public CaptureConfig build() {
            return new CaptureConfig(this);
        }
    }
}

