/*
 * Decompiled with CFR 0.152.
 */
package com.ethlo.time;

import com.ethlo.ascii.TableTheme;
import com.ethlo.time.CaptureConfig;
import com.ethlo.time.ChronographData;
import com.ethlo.time.OutputConfig;
import com.ethlo.time.RateLimitedTaskInfo;
import com.ethlo.time.Report;
import com.ethlo.time.TaskInfo;
import com.ethlo.time.TaskPerformanceStatistics;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class Chronograph {
    private static TableTheme theme = TableTheme.DEFAULT;
    private static OutputConfig outputConfig = OutputConfig.DEFAULT;
    private final Map<String, TaskInfo> taskInfos = new LinkedHashMap<String, TaskInfo>();
    private final CaptureConfig captureConfig;
    private final String name;

    public Chronograph(String name) {
        this(name, CaptureConfig.DEFAULT);
    }

    public Chronograph(CaptureConfig captureConfig) {
        this("", captureConfig);
    }

    public Chronograph(String name, CaptureConfig captureConfig) {
        this.name = name;
        this.captureConfig = captureConfig;
    }

    public static Chronograph create() {
        return new Chronograph("");
    }

    public static Chronograph create(CaptureConfig captureConfig) {
        return Chronograph.create("", captureConfig);
    }

    public static Chronograph create(String name) {
        return new Chronograph(name);
    }

    public static Chronograph create(String name, CaptureConfig captureConfig) {
        return new Chronograph(name, captureConfig);
    }

    public void timed(String taskName, Runnable task) {
        try {
            this.start(taskName);
            task.run();
        }
        finally {
            this.stop(taskName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R, T> R timedFunction(String taskName, Function<T, R> task, T input) {
        try {
            this.start(taskName);
            R r = task.apply(input);
            return r;
        }
        finally {
            this.stop(taskName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R, T> R timedSupplier(String taskName, Supplier<R> task) {
        try {
            this.start(taskName);
            R r = task.get();
            return r;
        }
        finally {
            this.stop(taskName);
        }
    }

    public String prettyPrint(String title) {
        return Report.prettyPrint(this.getTaskData(), outputConfig.title(title), theme);
    }

    public String prettyPrint() {
        return Report.prettyPrint(this.getTaskData(), outputConfig, theme);
    }

    public void start(String task) {
        if (task == null) {
            throw new IllegalArgumentException("task cannot be null");
        }
        TaskInfo taskInfo = this.taskInfos.computeIfAbsent(task, t -> this.captureConfig.getMinInterval().equals(Duration.ZERO) ? new TaskInfo(task) : new RateLimitedTaskInfo(task, this.captureConfig.getMinInterval()));
        taskInfo.start();
    }

    public void stop() {
        long ts = System.nanoTime();
        for (TaskInfo taskInfo : this.taskInfos.values()) {
            boolean shouldLog = taskInfo.stopped(ts, true);
            if (!shouldLog) continue;
            taskInfo.logTiming(ts);
        }
    }

    public boolean isAnyRunning() {
        return this.taskInfos.values().stream().anyMatch(TaskInfo::isRunning);
    }

    public void stop(String task) {
        long ts = System.nanoTime();
        TaskInfo taskInfo = this.taskInfos.get(task);
        if (taskInfo == null) {
            throw new IllegalStateException("No started task with name " + task);
        }
        if (taskInfo.stopped(ts, false)) {
            taskInfo.logTiming(ts);
        }
    }

    public void resetAll() {
        this.taskInfos.clear();
    }

    public TaskInfo getTasks(String task) {
        return Optional.ofNullable(this.taskInfos.get(task)).orElseThrow(() -> new IllegalStateException("Unknown task " + task));
    }

    public List<TaskInfo> getTasks() {
        return Collections.unmodifiableList(new ArrayList<TaskInfo>(this.taskInfos.values()));
    }

    public boolean isRunning(String task) {
        TaskInfo taskInfo = this.taskInfos.get(task);
        return taskInfo != null && taskInfo.isRunning();
    }

    public Duration getTotalTime() {
        return Duration.ofNanos(this.taskInfos.values().stream().map(TaskInfo::getTotalTaskTime).map(Duration::toNanos).reduce(0L, Long::sum));
    }

    public ChronographData getTaskData() {
        List<TaskPerformanceStatistics> stats = this.getTasks().stream().map(task -> new TaskPerformanceStatistics(task.getName(), task.getSampleSize(), task.getDurationStatistics(), task.getThroughputStatistics())).collect(Collectors.toList());
        return new ChronographData(this.name, stats, this.getTotalTime());
    }
}

