/*
 * Decompiled with CFR 0.152.
 */
package com.ethlo.time;

import com.ethlo.time.Chronograph;
import com.ethlo.time.TaskPerformanceStatistics;
import java.time.Duration;
import java.util.LinkedList;
import java.util.List;

public class ChronographData {
    private final String name;
    private final List<TaskPerformanceStatistics> taskStatistics;
    private final Duration totalTime;

    public ChronographData(String name, List<TaskPerformanceStatistics> taskStatistics, Duration totalTime) {
        this.name = name;
        this.taskStatistics = taskStatistics;
        this.totalTime = totalTime;
    }

    public static ChronographData combine(String name, List<Chronograph> toCombine) {
        LinkedList<TaskPerformanceStatistics> all = new LinkedList<TaskPerformanceStatistics>();
        for (Chronograph c : toCombine) {
            ChronographData taskData = c.getTaskData();
            String runName = taskData.name;
            for (TaskPerformanceStatistics taskStats : taskData.taskStatistics) {
                String fullName = runName != null && runName.length() > 0 ? runName + " - " + taskStats.getName() : taskStats.getName();
                all.add(new TaskPerformanceStatistics(fullName, taskStats.getSampleSize(), taskStats.getDurationStatistics(), taskStats.getThroughputStatistics()));
            }
        }
        Duration total = toCombine.stream().map(Chronograph::getTaskData).map(ChronographData::getTotalTime).reduce(Duration.ZERO, Duration::plus);
        return new ChronographData(name, all, total);
    }

    public String getName() {
        return this.name;
    }

    public List<TaskPerformanceStatistics> getTaskStatistics() {
        return this.taskStatistics;
    }

    public Duration getTotalTime() {
        return this.totalTime;
    }

    public boolean isEmpty() {
        return this.taskStatistics.isEmpty();
    }
}

