/*
 * Decompiled with CFR 0.152.
 */
package com.ethlo.time;

import com.ethlo.time.PresentationMode;

public class OutputConfig {
    public static final OutputConfig COMPACT = new OutputConfig().median(true).invocations(true).standardDeviation(true).total(true).percentage(true);
    public static final OutputConfig DEFAULT = new OutputConfig().average(true).median(true).min(true).max(true).invocations(true).standardDeviation(true).total(true).percentage(true);
    public static final OutputConfig EXTENDED = new OutputConfig().average(true).percentiles(95.0, 99.0, 99.9).median(true).min(true).max(true).invocations(true).standardDeviation(true).total(true).percentage(true);
    private String title;
    private double[] percentiles;
    private boolean median;
    private boolean average;
    private boolean min;
    private boolean max;
    private boolean invocations;
    private boolean standardDeviation;
    private boolean total;
    private boolean percentage;
    private PresentationMode mode = PresentationMode.DURATION;
    private boolean benchmarkMode = false;
    private boolean formatting = true;

    public OutputConfig() {
    }

    private OutputConfig(Builder builder) {
        this.title = builder.title;
        this.percentiles = builder.percentiles;
        this.median = builder.median;
        this.average = builder.average;
        this.min = builder.min;
        this.max = builder.max;
        this.invocations = builder.invocations;
        this.standardDeviation = builder.standardDeviation;
        this.total = builder.total;
        this.percentage = builder.percentage;
        this.mode = builder.mode;
        this.benchmarkMode = builder.benchmarkMode;
        this.formatting = builder.formatting;
    }

    public String title() {
        return this.title;
    }

    public double[] percentiles() {
        return this.percentiles;
    }

    public boolean median() {
        return this.median;
    }

    public boolean mean() {
        return this.average;
    }

    public boolean min() {
        return this.min;
    }

    public boolean max() {
        return this.max;
    }

    public boolean invocations() {
        return this.invocations;
    }

    public boolean standardDeviation() {
        return this.standardDeviation;
    }

    public boolean total() {
        return this.total;
    }

    public boolean percentage() {
        return this.percentage;
    }

    public PresentationMode getMode() {
        return this.mode;
    }

    public boolean benchmarkMode() {
        return this.benchmarkMode;
    }

    public boolean formatting() {
        return this.formatting;
    }

    public OutputConfig mode(PresentationMode mode) {
        return new OutputConfig(new Builder(this).mode(mode));
    }

    public OutputConfig title(String title) {
        return new OutputConfig(new Builder(this).title(title));
    }

    public OutputConfig percentiles(double ... percentiles) {
        return new OutputConfig(new Builder(this).percentiles(percentiles));
    }

    public OutputConfig median(boolean median) {
        return new OutputConfig(new Builder(this).median(median));
    }

    public OutputConfig average(boolean average) {
        return new OutputConfig(new Builder(this).average(average));
    }

    public OutputConfig min(boolean min) {
        return new OutputConfig(new Builder(this).min(min));
    }

    public OutputConfig max(boolean max) {
        return new OutputConfig(new Builder(this).max(max));
    }

    public OutputConfig invocations(boolean invocations) {
        return new OutputConfig(new Builder(this).invocations(invocations));
    }

    public OutputConfig standardDeviation(boolean standardDeviation) {
        return new OutputConfig(new Builder(this).standardDeviation(standardDeviation));
    }

    public OutputConfig total(boolean total) {
        return new OutputConfig(new Builder(this).total(total));
    }

    public OutputConfig percentage(boolean percentage) {
        return new OutputConfig(new Builder(this).percentage(percentage));
    }

    public OutputConfig benchmarkMode(boolean b) {
        return new OutputConfig(new Builder(this).benchmarkMode(b));
    }

    public OutputConfig formatting(boolean b) {
        return new OutputConfig(new Builder(this).formatting(b));
    }

    public static class Builder {
        private PresentationMode mode;
        private String title;
        private double[] percentiles;
        private boolean median;
        private boolean average;
        private boolean min;
        private boolean max;
        private boolean invocations;
        private boolean standardDeviation;
        private boolean total;
        private boolean percentage;
        private boolean benchmarkMode;
        private boolean formatting;

        private Builder(OutputConfig config) {
            this.total = config.total;
            this.percentage = config.percentage;
            this.standardDeviation = config.standardDeviation;
            this.min = config.min;
            this.max = config.max;
            this.median = config.median;
            this.percentiles = config.percentiles;
            this.invocations = config.invocations;
            this.average = config.average;
            this.title = config.title;
            this.mode = config.mode;
            this.benchmarkMode = config.benchmarkMode;
            this.formatting = config.formatting;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder percentiles(double ... percentiles) {
            this.percentiles = percentiles;
            return this;
        }

        public Builder median(boolean median) {
            this.median = median;
            return this;
        }

        public Builder average(boolean average) {
            this.average = average;
            return this;
        }

        public Builder min(boolean min) {
            this.min = min;
            return this;
        }

        public Builder max(boolean max) {
            this.max = max;
            return this;
        }

        public Builder invocations(boolean invocations) {
            this.invocations = invocations;
            return this;
        }

        public Builder standardDeviation(boolean standardDeviation) {
            this.standardDeviation = standardDeviation;
            return this;
        }

        public Builder total(boolean total) {
            this.total = total;
            return this;
        }

        public Builder percentage(boolean percentage) {
            this.percentage = percentage;
            return this;
        }

        public Builder mode(PresentationMode mode) {
            this.mode = mode;
            return this;
        }

        public Builder benchmarkMode(boolean b) {
            this.benchmarkMode = b;
            return this;
        }

        public Builder formatting(boolean b) {
            this.formatting = b;
            return this;
        }
    }
}

