/*
 * Decompiled with CFR 0.152.
 */
package com.ethlo.time;

import com.ethlo.time.TaskInfo;
import com.ethlo.time.statistics.DurationPerformanceStatistics;
import com.ethlo.time.statistics.PerformanceStatistics;
import com.ethlo.util.IndexedCollectionStatistics;
import java.time.Duration;

public class RateLimitedTaskInfo
extends TaskInfo {
    private final long nanosInterval;
    private long lastStopped;
    private int totalInvocations;
    private long totalElapsed;

    RateLimitedTaskInfo(String name, Duration minInterval) {
        super(name);
        this.nanosInterval = minInterval.toNanos();
    }

    @Override
    boolean stopped(long ts, boolean ignoreState) {
        super.stopped(ts, ignoreState);
        long elapsed = ts - this.lastStopped;
        if (this.lastStopped == 0L || elapsed > this.nanosInterval) {
            this.lastStopped = ts;
            ++this.totalInvocations;
            this.totalElapsed += ts - super.getTaskStartTimestamp();
            return true;
        }
        ++this.totalInvocations;
        this.totalElapsed += ts - super.getTaskStartTimestamp();
        return false;
    }

    @Override
    public long getTotalTaskInvocations() {
        return this.totalInvocations;
    }

    @Override
    public Duration getTotalTaskTime() {
        return Duration.ofNanos(this.totalElapsed);
    }

    @Override
    public PerformanceStatistics<Duration> getDurationStatistics() {
        IndexedCollectionStatistics stats = new IndexedCollectionStatistics(this.getData());
        return new DurationPerformanceStatistics(stats, this.totalInvocations, Duration.ofNanos(this.totalElapsed));
    }
}

