/*
 * Decompiled with CFR 0.152.
 */
package com.ethlo.time;

import com.ethlo.ascii.SeparatorRow;
import com.ethlo.ascii.Table;
import com.ethlo.ascii.TableCell;
import com.ethlo.ascii.TableRow;
import com.ethlo.ascii.TableTheme;
import com.ethlo.time.ChronographData;
import com.ethlo.time.OutputConfig;
import com.ethlo.time.PresentationMode;
import com.ethlo.time.ReportUtil;
import com.ethlo.time.TaskPerformanceStatistics;
import com.ethlo.time.statistics.PerformanceStatistics;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;

public class Report {
    public static final double NANOS_PER_SECOND = 1.0E9;

    public static String prettyPrint(ChronographData chronographData, OutputConfig outputConfig, TableTheme theme) {
        if (chronographData.isEmpty()) {
            return "No performance data";
        }
        LinkedList<TableRow> rows = new LinkedList<TableRow>();
        NumberFormat pf = NumberFormat.getPercentInstance();
        pf.setMinimumFractionDigits(1);
        pf.setMaximumFractionDigits(1);
        pf.setGroupingUsed(false);
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setRoundingMode(RoundingMode.HALF_UP);
        nf.setGroupingUsed(true);
        rows.add(SeparatorRow.getInstance());
        rows.add(Report.getHeaderRow(outputConfig));
        rows.add(SeparatorRow.getInstance());
        ArrayList<TaskPerformanceStatistics> taskPerformanceStats = new ArrayList<TaskPerformanceStatistics>(chronographData.getTaskStatistics());
        taskPerformanceStats.sort(Report.comparator(outputConfig));
        for (TaskPerformanceStatistics taskStats : taskPerformanceStats) {
            rows.add(Report.getTableRow(outputConfig, chronographData.getTotalTime(), taskStats, pf, nf));
        }
        if (taskPerformanceStats.size() > 1) {
            rows.add(SeparatorRow.getInstance());
            rows.add(Report.totals(outputConfig, chronographData));
        }
        rows.add(SeparatorRow.getInstance());
        return new Table(theme, rows).render(outputConfig.title() != null ? outputConfig.title() : chronographData.getName());
    }

    private static Comparator<? super TaskPerformanceStatistics> comparator(OutputConfig outputConfig) {
        if (outputConfig.benchmarkMode()) {
            return Comparator.comparingDouble(a -> a.getThroughputStatistics().getAverage()).reversed();
        }
        return (a, b) -> 0;
    }

    private static TableRow getTableRow(OutputConfig outputConfig, Duration totalTime, TaskPerformanceStatistics taskStats, NumberFormat pf, NumberFormat nf) {
        TableRow row = new TableRow();
        row.append(new TableCell(taskStats.getName()));
        long invocations = taskStats.getThroughputStatistics().getTotalInvocations();
        boolean multipleInvocations = invocations > 1L;
        PerformanceStatistics<Duration> durationStatistics = taskStats.getDurationStatistics();
        PerformanceStatistics<Double> throughputStatistics = taskStats.getThroughputStatistics();
        Report.outputTotal(outputConfig, row, durationStatistics);
        Report.addInvocations(outputConfig, taskStats, nf, row, invocations);
        Report.outputPercentage(outputConfig, totalTime, pf, row, durationStatistics);
        Report.conditionalOutput(outputConfig, row, multipleInvocations, outputConfig.median(), durationStatistics.getMedian(), throughputStatistics.getMedian());
        Report.conditionalOutput(outputConfig, row, multipleInvocations, outputConfig.standardDeviation(), durationStatistics.getStandardDeviation(), throughputStatistics.getStandardDeviation());
        Report.conditionalOutput(outputConfig, row, multipleInvocations, outputConfig.mean(), durationStatistics.getAverage(), throughputStatistics.getAverage());
        Report.conditionalOutput(outputConfig, row, multipleInvocations, outputConfig.min(), durationStatistics.getMin(), throughputStatistics.getMin());
        Report.conditionalOutput(outputConfig, row, multipleInvocations, outputConfig.max(), durationStatistics.getMax(), throughputStatistics.getMax());
        Report.outputPercentiles(outputConfig, row, multipleInvocations, durationStatistics, throughputStatistics);
        return row;
    }

    private static void outputPercentiles(OutputConfig outputConfig, TableRow row, boolean multipleInvocations, PerformanceStatistics<Duration> durationStatistics, PerformanceStatistics<Double> throughputStatistics) {
        if (outputConfig.percentiles() != null) {
            for (double percentile : outputConfig.percentiles()) {
                Report.outputCell(outputConfig, row, multipleInvocations, durationStatistics.getPercentile(percentile), throughputStatistics.getPercentile(percentile));
            }
        }
    }

    private static void outputTotal(OutputConfig outputConfig, TableRow row, PerformanceStatistics<Duration> durationStatistics) {
        if (outputConfig.total()) {
            String str = outputConfig.formatting() ? ReportUtil.humanReadable(durationStatistics.getElapsedTotal()) : Report.getRawNumberFormat().format((double)durationStatistics.getElapsedTotal().toNanos() / 1.0E9);
            row.append(new TableCell(str, false, true));
        }
    }

    private static void outputPercentage(OutputConfig outputConfig, Duration totalTime, NumberFormat pf, TableRow row, PerformanceStatistics<Duration> durationStatistics) {
        if (outputConfig.percentage()) {
            double pct = totalTime.isZero() ? 0.0 : (double)durationStatistics.getElapsedTotal().toNanos() / (double)totalTime.toNanos();
            row.append(new TableCell(outputConfig.formatting() ? pf.format(pct) : Report.getRawNumberFormat().format(pct), false, true));
        }
    }

    private static void addInvocations(OutputConfig outputConfig, TaskPerformanceStatistics taskStats, NumberFormat nf, TableRow row, long invocations) {
        if (outputConfig.invocations()) {
            String invocationsStr = taskStats.getSampleSize() != invocations && outputConfig.formatting() ? "(" + nf.format(taskStats.getSampleSize()) + ") " + nf.format(invocations) : (outputConfig.formatting() ? nf.format(invocations) : Report.getRawNumberFormat().format(invocations));
            row.append(new TableCell(invocationsStr, false, true));
        }
    }

    private static void conditionalOutput(OutputConfig outputConfig, TableRow row, boolean multipleInvocations, boolean shouldShow, Duration duration, Double throughput) {
        if (shouldShow) {
            Report.outputCell(outputConfig, row, multipleInvocations, duration, throughput);
        }
    }

    private static void outputCell(OutputConfig outputConfig, TableRow row, boolean multipleInvocations, Duration duration, Double throughput) {
        if (multipleInvocations) {
            String str;
            if (outputConfig.formatting()) {
                str = outputConfig.getMode() == PresentationMode.DURATION ? ReportUtil.humanReadable(duration) : ReportUtil.humanReadable(throughput);
            } else {
                NumberFormat nf = Report.getRawNumberFormat();
                str = outputConfig.getMode() == PresentationMode.DURATION ? Long.toString(duration.toNanos()) : nf.format(throughput);
            }
            row.append(new TableCell(str, false, true));
        } else {
            row.append(new TableCell(""));
        }
    }

    private static NumberFormat getRawNumberFormat() {
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setRoundingMode(RoundingMode.HALF_UP);
        nf.setMinimumFractionDigits(6);
        nf.setMaximumFractionDigits(6);
        nf.setGroupingUsed(false);
        return nf;
    }

    private static TableRow getHeaderRow(OutputConfig outputConfig) {
        TableRow headerRow = new TableRow();
        headerRow.append("Task");
        if (outputConfig.total()) {
            headerRow.append("Total");
        }
        if (outputConfig.invocations()) {
            headerRow.append("Count");
        }
        if (outputConfig.percentage()) {
            headerRow.append("%");
        }
        if (outputConfig.median()) {
            headerRow.append("Median");
        }
        if (outputConfig.standardDeviation()) {
            headerRow.append("Std dev");
        }
        if (outputConfig.mean()) {
            headerRow.append("Mean");
        }
        if (outputConfig.min()) {
            headerRow.append("Min");
        }
        if (outputConfig.max()) {
            headerRow.append("Max");
        }
        if (outputConfig.percentiles() != null) {
            NumberFormat nf = NumberFormat.getNumberInstance();
            nf.setMinimumFractionDigits(0);
            for (double percentile : outputConfig.percentiles()) {
                headerRow.append(nf.format(percentile) + " pctl");
            }
        }
        return headerRow;
    }

    private static TableRow totals(OutputConfig outputConfig, ChronographData chronographData) {
        long totalInvocations = chronographData.getTaskStatistics().stream().map(t -> t.getDurationStatistics().getTotalInvocations()).reduce(0L, Long::sum);
        return new TableRow().append(new TableCell("Sum", false, false)).append(new TableCell(outputConfig.formatting() ? ReportUtil.humanReadable(chronographData.getTotalTime()) : Report.getRawNumberFormat().format((double)chronographData.getTotalTime().toNanos() / 1.0E9), false, true)).append(new TableCell(outputConfig.formatting() ? ReportUtil.formatInteger(totalInvocations) : Report.getRawNumberFormat().format(totalInvocations), false, true)).append(new TableCell(outputConfig.formatting() ? "100.0%" : "1.000000", false, true));
    }
}

