/*
 * Decompiled with CFR 0.152.
 */
package com.ethlo.time;

import java.math.RoundingMode;
import java.text.NumberFormat;
import java.time.Duration;

public class ReportUtil {
    public static final int SECONDS_PER_HOUR = 3600;
    public static final int SECONDS_PER_MINUTE = 60;
    public static final int NANOS_PER_MILLI = 1000000;
    private static final int NANOS_PER_MICRO = 1000;
    private static final long MICRO = 1000000L;
    private static final long MILLI = 1000L;

    public static String humanReadable(Duration duration) {
        boolean hasSecondOrMore;
        long seconds = duration.getSeconds();
        int hours = (int)seconds / 3600;
        int remainder = (int)seconds - hours * 3600;
        int mins = remainder / 60;
        int secs = remainder -= mins * 60;
        long nanos = duration.getNano();
        int millis = (int)nanos / 1000000;
        remainder = (int)nanos - millis * 1000000;
        int micros = remainder / 1000;
        int nano = remainder -= micros * 1000;
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMinimumIntegerDigits(2);
        NumberFormat df = NumberFormat.getNumberInstance();
        df.setMinimumFractionDigits(2);
        df.setMaximumFractionDigits(2);
        df.setRoundingMode(RoundingMode.HALF_UP);
        StringBuilder sb = new StringBuilder();
        if (hours > 0) {
            sb.append(nf.format(hours)).append(":");
        }
        if (hours > 0 || mins > 0) {
            sb.append(nf.format(mins)).append(":");
        }
        boolean hasMinuteOrMore = hours > 0 || mins > 0;
        boolean bl = hasSecondOrMore = hasMinuteOrMore || secs > 0;
        if (hasSecondOrMore && !hasMinuteOrMore) {
            NumberFormat dfSec = NumberFormat.getNumberInstance();
            dfSec.setMinimumFractionDigits(0);
            dfSec.setMaximumFractionDigits(0);
            dfSec.setMinimumIntegerDigits(3);
            dfSec.setMaximumIntegerDigits(3);
            sb.append(seconds).append('.').append(dfSec.format((double)nanos / 1000000.0)).append(" s");
        } else if (hasSecondOrMore) {
            sb.append(nf.format(secs)).append(".").append(millis);
        } else {
            if (millis > 0) {
                sb.append(df.format((double)nanos / 1000000.0)).append(" ms ");
            }
            if (millis == 0 && micros > 0) {
                sb.append(df.format((double)nanos / 1000.0)).append(" \u03bcs ");
            }
            if (millis == 0 && micros == 0 && nano > 0) {
                sb.append(nano).append(" ns ");
            }
        }
        return sb.toString().trim();
    }

    public static String humanReadable(double throughput) {
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setRoundingMode(RoundingMode.HALF_UP);
        nf.setGroupingUsed(true);
        if (throughput > 1000000.0) {
            nf.setMaximumFractionDigits(0);
        } else if (throughput > 1000.0) {
            nf.setMaximumFractionDigits(1);
        } else {
            nf.setMaximumFractionDigits(2);
        }
        return nf.format(throughput);
    }

    public static String formatInteger(long value) {
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setGroupingUsed(true);
        return nf.format(value);
    }
}

