/*
 * Decompiled with CFR 0.152.
 */
package com.ethlo.time;

import com.ethlo.time.statistics.DurationPerformanceStatistics;
import com.ethlo.time.statistics.PerformanceStatistics;
import com.ethlo.time.statistics.ThroughputPerformanceStatistics;
import com.ethlo.util.IndexedCollection;
import com.ethlo.util.IndexedCollectionStatistics;
import com.ethlo.util.LongList;
import java.time.Duration;

public class TaskInfo {
    private final String name;
    private final IndexedCollection<Long> data;
    private long taskStartTimestamp;
    private boolean running = false;

    TaskInfo(String name) {
        this.name = name;
        this.data = new LongList();
    }

    long start() {
        if (this.running) {
            throw new IllegalStateException("Task " + this.name + " is already started");
        }
        this.running = true;
        this.taskStartTimestamp = System.nanoTime();
        return this.taskStartTimestamp;
    }

    public String getName() {
        return this.name;
    }

    public long getTotalTaskInvocations() {
        return this.data.size();
    }

    public long getSampleSize() {
        return this.data.size();
    }

    public boolean isRunning() {
        return this.running;
    }

    boolean stopped(long ts, boolean ignoreState) {
        if (!this.running && !ignoreState) {
            throw new IllegalStateException("Task " + this.name + " is not started");
        }
        if (this.running) {
            this.running = false;
            return true;
        }
        return false;
    }

    void logTiming(long ts) {
        long duration = ts - this.taskStartTimestamp;
        this.data.add(duration);
    }

    public PerformanceStatistics<Duration> getDurationStatistics() {
        IndexedCollectionStatistics stats = new IndexedCollectionStatistics(this.data);
        return new DurationPerformanceStatistics(stats, this.getTotalTaskInvocations(), Duration.ofNanos(stats.sum()));
    }

    public PerformanceStatistics<Double> getThroughputStatistics() {
        IndexedCollectionStatistics stats = new IndexedCollectionStatistics(this.data);
        return new ThroughputPerformanceStatistics(stats, this.getTotalTaskInvocations(), this.getTotalTaskTime());
    }

    public Duration getTotalTaskTime() {
        return Duration.ofNanos(this.data.stream().reduce(0L, Long::sum));
    }

    protected long getTaskStartTimestamp() {
        return this.taskStartTimestamp;
    }

    protected IndexedCollection<Long> getData() {
        return this.data;
    }
}

