/*
 * Decompiled with CFR 0.152.
 */
package com.ethlo.time.statistics;

import com.ethlo.time.statistics.PerformanceStatistics;
import com.ethlo.util.IndexedCollection;
import com.ethlo.util.IndexedCollectionStatistics;
import com.ethlo.util.MathUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Duration;
import java.util.Iterator;

public class DurationPerformanceStatistics
extends PerformanceStatistics<Duration> {
    public DurationPerformanceStatistics(IndexedCollectionStatistics collectionStatistics, long totalInvocations, Duration elapsedTotal) {
        super(collectionStatistics, totalInvocations, elapsedTotal);
    }

    @Override
    public Duration getAverage() {
        if (this.getTotalInvocations() == 0L) {
            return Duration.ZERO;
        }
        return Duration.ofNanos(BigDecimal.valueOf(this.getElapsedTotal().toNanos()).divide(BigDecimal.valueOf(this.getTotalInvocations()), RoundingMode.HALF_UP).longValue());
    }

    @Override
    public Duration getMedian() {
        return Duration.ofNanos((long)this.collectionStatistics.getMedian());
    }

    @Override
    public Duration getPercentile(double limit) {
        return Duration.ofNanos((long)this.collectionStatistics.getPercentile(limit));
    }

    @Override
    public Duration getMin() {
        return Duration.ofNanos(this.collectionStatistics.getMin());
    }

    @Override
    public Duration getMax() {
        return Duration.ofNanos(this.collectionStatistics.getMax());
    }

    @Override
    public Duration getStandardDeviation() {
        IndexedCollection<Long> list = this.collectionStatistics.getList();
        int count = list.size();
        double average = this.getAverage().toNanos();
        BigDecimal sd = BigDecimal.valueOf(0L);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            long l = (Long)iterator.next();
            double val = Math.pow(((double)l - average) / (double)count, 2.0);
            sd = sd.add(BigDecimal.valueOf(val));
        }
        return Duration.ofNanos(MathUtil.sqrt(sd).longValue());
    }
}

