/*
 * Decompiled with CFR 0.152.
 */
package com.ethlo.time.statistics;

import com.ethlo.time.statistics.PerformanceStatistics;
import com.ethlo.util.IndexedCollection;
import com.ethlo.util.IndexedCollectionStatistics;
import com.ethlo.util.MathUtil;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.time.Duration;
import java.util.Iterator;

public class ThroughputPerformanceStatistics
extends PerformanceStatistics<Double> {
    private static final double D_NANOS = 1.0E9;

    public ThroughputPerformanceStatistics(IndexedCollectionStatistics collectionStatistics, long totalInvocations, Duration elapsedTotal) {
        super(collectionStatistics, totalInvocations, elapsedTotal);
    }

    @Override
    public Double getAverage() {
        if (this.getTotalInvocations() == 0L) {
            return Double.NaN;
        }
        return this.divide(this.totalInvocations, this.elapsedTotal.toNanos());
    }

    private Double divide(long events, long nanos) {
        BigDecimal second = BigDecimal.valueOf(nanos).divide(BigDecimal.valueOf(1.0E9), MathContext.DECIMAL128);
        return BigDecimal.valueOf(events).divide(second, RoundingMode.HALF_UP).doubleValue();
    }

    @Override
    public Double getMedian() {
        return 1.0E9 / this.collectionStatistics.getMedian();
    }

    @Override
    public Double getPercentile(double limit) {
        return 1.0E9 / this.collectionStatistics.getPercentile(limit);
    }

    @Override
    public Double getMin() {
        long slowestNanos = this.collectionStatistics.getMax();
        return 1.0E9 / (double)slowestNanos;
    }

    @Override
    public Double getMax() {
        long fastestNanos = this.collectionStatistics.getMin();
        return 1.0E9 / (double)fastestNanos;
    }

    @Override
    public Double getStandardDeviation() {
        IndexedCollection<Long> list = this.collectionStatistics.getList();
        int count = list.size();
        double average = this.getAverage();
        BigDecimal sd = BigDecimal.valueOf(0L);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            long l = (Long)iterator.next();
            double val = Math.pow((1.0E9 / (double)l - average) / (double)count, 2.0);
            sd = sd.add(BigDecimal.valueOf(val));
        }
        return MathUtil.sqrt(sd).doubleValue();
    }
}

