/*
 * Decompiled with CFR 0.152.
 */
package com.ethlo.util;

import com.ethlo.util.IndexedCollection;
import java.math.BigInteger;
import java.util.Iterator;

public class IndexedCollectionStatistics {
    private final IndexedCollection<Long> list;
    private final long sum;

    public IndexedCollectionStatistics(IndexedCollection<Long> list) {
        this.list = list;
        list.sort();
        this.sum = this.calculateSum();
    }

    private long calculateSum() {
        long sum = 0L;
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            long l = (Long)iterator.next();
            sum += l;
        }
        return sum;
    }

    public long getMin() {
        return this.list.get(0);
    }

    public long getMax() {
        return this.list.get(this.list.size() - 1);
    }

    public double getAverage() {
        BigInteger sum = BigInteger.ZERO;
        for (Long l : this.list) {
            BigInteger bi = BigInteger.valueOf(l);
            sum = sum.add(bi);
        }
        return sum.divide(BigInteger.valueOf(this.list.size())).doubleValue();
    }

    public double getPercentile(double percentile) {
        int index = (int)Math.ceil(percentile / 100.0 * (double)this.list.size());
        return this.list.get(index - 1).longValue();
    }

    public double getMedian() {
        int pivot = this.list.size() / 2;
        if (pivot * 2 == this.list.size()) {
            return (double)(this.list.get(pivot - 1) + this.list.get(pivot)) / 2.0;
        }
        return this.list.get(pivot).longValue();
    }

    public long sum() {
        return this.sum;
    }

    public long size() {
        return this.list.size();
    }

    public IndexedCollection<Long> getList() {
        return this.list;
    }
}

