/*
 * Decompiled with CFR 0.152.
 */
package com.ethlo.util;

import com.ethlo.util.IndexedCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class LongList
implements IndexedCollection<Long> {
    private static final int DEFAULT_BLOCK_SIZE = 1000;
    private final int blockSize;
    private final List<long[]> blocks = new ArrayList<long[]>(16);
    private int index = 0;
    private boolean isSorted = false;

    public LongList() {
        this(1000);
    }

    public LongList(int blockSize) {
        this.blockSize = blockSize;
    }

    @Override
    public void add(long l) {
        if (this.index % this.blockSize == 0) {
            this.blocks.add(new long[this.blockSize]);
        }
        int blockIndex = this.index / this.blockSize;
        this.blocks.get((int)blockIndex)[this.index % this.blockSize] = l;
        ++this.index;
        this.isSorted = false;
    }

    @Override
    public Long get(int index) {
        if (index < 0 || index >= this.index) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int blockIndex = index / this.blockSize;
        return this.blocks.get(blockIndex)[index % this.blockSize];
    }

    @Override
    public int size() {
        return this.index;
    }

    @Override
    public void set(int index, Long l) {
        int blockIndex = index / this.blockSize;
        this.blocks.get((int)blockIndex)[index % this.blockSize] = Objects.requireNonNull(l);
        this.isSorted = false;
    }

    @Override
    public Iterator<Long> iterator() {
        return new Iterator<Long>(){
            private int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < LongList.this.index;
            }

            @Override
            public Long next() {
                return LongList.this.get(this.idx++);
            }
        };
    }

    @Override
    public void sort() {
        if (!this.isSorted) {
            int size;
            boolean isLast;
            int offset;
            int i;
            long[] all = new long[this.size()];
            for (i = 0; i < this.blocks.size(); ++i) {
                long[] src = this.blocks.get(i);
                offset = i * this.blockSize;
                boolean bl = isLast = i == this.blocks.size() - 1;
                size = isLast ? (this.index % this.blockSize == 0 ? this.blockSize : this.index % this.blockSize) : this.blockSize;
                System.arraycopy(src, 0, all, offset, size);
            }
            Arrays.sort(all);
            for (i = 0; i < this.blocks.size(); ++i) {
                long[] target = this.blocks.get(i);
                offset = i * this.blockSize;
                boolean bl = isLast = i == this.blocks.size() - 1;
                size = isLast ? (this.index % this.blockSize == 0 ? this.blockSize : this.index % this.blockSize) : this.blockSize;
                System.arraycopy(all, offset, target, 0, size);
            }
            this.isSorted = true;
        }
    }

    @Override
    public Stream<Long> stream() {
        Iterable iterable = this::iterator;
        return StreamSupport.stream(iterable.spliterator(), false);
    }
}

