/*
 * Decompiled with CFR 0.152.
 */
package com.ethlo.time;

import com.ethlo.time.Field;
import com.ethlo.time.TimezoneOffset;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.YearMonth;
import java.util.Optional;

public class DateTime {
    private final Field field;
    private final int year;
    private final int month;
    private final int day;
    private final int hour;
    private final int minute;
    private final int second;
    private final int nano;
    private final TimezoneOffset offset;

    public DateTime(Field field, int year, int month, int day, int hour, int minute, int second, int nano, TimezoneOffset offset) {
        this.field = field;
        this.year = year;
        this.month = this.assertSize(month, 1, 12, Field.MONTH);
        this.day = this.assertSize(day, 1, 31, Field.DAY);
        this.hour = this.assertSize(hour, 0, 23, Field.HOUR);
        this.minute = this.assertSize(minute, 0, 59, Field.MINUTE);
        this.second = this.assertSize(second, 0, 60, Field.SECOND);
        this.nano = this.assertSize(nano, 0, 999999999, Field.NANO);
        this.offset = offset;
    }

    public static DateTime of(int year, int month, int day, int hour, int minute, int second, int nanos, TimezoneOffset offset) {
        return new DateTime(Field.SECOND, year, month, day, hour, minute, second, nanos, offset);
    }

    public static DateTime ofYear(int year) {
        return new DateTime(Field.YEAR, year, 0, 0, 0, 0, 0, 0, null);
    }

    public static DateTime ofYearMonth(int years, int months) {
        return new DateTime(Field.MONTH, years, months, 0, 0, 0, 0, 0, null);
    }

    public static DateTime ofDate(int years, int months, int days) {
        return new DateTime(Field.DAY, years, months, days, 0, 0, 0, 0, null);
    }

    public static DateTime of(int years, int months, int days, int hours, int minute, TimezoneOffset offset) {
        return new DateTime(Field.MINUTE, years, months, days, hours, minute, 0, 0, offset);
    }

    public static DateTime of(OffsetDateTime dateTime) {
        return DateTime.of(dateTime.getYear(), dateTime.getMonthValue(), dateTime.getDayOfMonth(), dateTime.getHour(), dateTime.getMinute(), dateTime.getSecond(), dateTime.getNano(), TimezoneOffset.of(dateTime.getOffset()));
    }

    private int assertSize(int value, int min, int max, Field field) {
        if (value > max) {
            throw new DateTimeException("Field " + field.name() + " out of bounds. Expected " + min + "-" + max + ", got " + value);
        }
        return value;
    }

    public boolean includesGranularity(Field field) {
        return field.ordinal() <= this.field.ordinal();
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDayOfMonth() {
        return this.day;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    public long getNano() {
        return this.nano;
    }

    public Optional<TimezoneOffset> getOffset() {
        return Optional.ofNullable(this.offset);
    }

    public YearMonth toYearMonth() {
        if (this.field.ordinal() >= Field.MONTH.ordinal()) {
            return YearMonth.of(this.year, this.month);
        }
        throw new DateTimeException("Missing field for date-time, found only " + this.field.name().toLowerCase());
    }

    public LocalDateTime toLocalDatetime() {
        if (this.field.ordinal() >= Field.MINUTE.ordinal()) {
            return LocalDateTime.of(this.year, this.month, this.day, this.hour, this.minute, this.second, this.nano);
        }
        throw new DateTimeException("Missing field for date-time, found only " + this.field.name().toLowerCase());
    }

    public OffsetDateTime toOffsetDatetime() {
        if (this.field.ordinal() >= Field.MINUTE.ordinal() && this.offset != null) {
            return OffsetDateTime.of(this.year, this.month, this.day, this.hour, this.minute, this.second, this.nano, this.offset.asJavaTimeOffset());
        }
        if (this.offset == null) {
            throw new DateTimeException("No zone offset information found");
        }
        throw new DateTimeException("Missing field for date-time, found only " + this.field.name().toLowerCase());
    }

    public LocalDate toLocalDate() {
        if (this.field.ordinal() >= Field.DAY.ordinal()) {
            return LocalDate.of(this.year, this.month, this.day);
        }
        throw new DateTimeException("Missing field day for LocalDate, found only " + this.field.name().toLowerCase());
    }

    public Field getField() {
        return this.field;
    }

    public DateTime assertMinGranularity(Field field) {
        if (!this.includesGranularity(field)) {
            throw new DateTimeException("No " + field.name() + " field found");
        }
        return this;
    }
}

