/*
 * Decompiled with CFR 0.152.
 */
package com.ethlo.zally;

import com.ethlo.zally.ApiReporter;
import com.ethlo.zally.OpenApiParser;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Arrays;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(threadSafe=true, name="report", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class ReportingMojo
extends AbstractMojo {
    @Parameter(required=true, defaultValue="${project.basedir}/src/main/resources/api.yaml", property="zally.source")
    private String source;
    @Parameter(property="zally.skip", defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;

    public void execute() throws MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping execution as requested");
            return;
        }
        boolean existsOnClassPath = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(this.source) != null;
        boolean existsOnFilesystem = Files.exists(Paths.get(this.source, new String[0]), new LinkOption[0]);
        if (!existsOnClassPath && !existsOnFilesystem) {
            throw new MojoFailureException("The specified source file could not be found: " + this.source);
        }
        this.getLog().info((CharSequence)("Analyzing file '" + this.source + "'"));
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"API path hierarchy:");
        String hierarchy = new ApiReporter(new OpenApiParser().parse(this.source)).render();
        Arrays.stream(hierarchy.split("\n")).forEach(line -> this.getLog().info((CharSequence)line));
        this.getLog().info((CharSequence)"");
    }
}

