/*
 * Decompiled with CFR 0.152.
 */
package com.ethlo.zally;

import com.ethlo.zally.ZallyRunner;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.zalando.zally.core.CheckDetails;
import org.zalando.zally.core.Result;
import org.zalando.zally.core.RuleDetails;
import org.zalando.zally.rule.api.Severity;

@Mojo(threadSafe=true, name="validate", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class ZallyMojo
extends AbstractMojo {
    private final ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    @Parameter(required=true, defaultValue="${project.basedir}/src/main/resources/api.yaml", property="zally.source")
    private String source;
    @Parameter(property="zally.failOn")
    private List<Severity> failOn;
    @Parameter(property="zally.resultFile")
    private String resultFile;
    @Parameter(property="zally.skip", defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter
    private Map<String, String> ruleConfigs;
    @Parameter
    private Set<String> skipRules;

    public ZallyMojo() {
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
    }

    public void execute() throws MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping execution as requested");
            return;
        }
        Config config = this.parseConfigMap(this.ruleConfigs).withFallback((ConfigMergeable)ConfigFactory.load((String)"reference"));
        ZallyRunner zallyRunner = new ZallyRunner(config, this.getLog());
        boolean existsOnClassPath = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(this.source) != null;
        boolean existsOnFilesystem = Files.exists(Paths.get(this.source, new String[0]), new LinkOption[0]);
        if (!existsOnClassPath && !existsOnFilesystem) {
            throw new MojoFailureException("The specified source file could not be found: " + this.source);
        }
        this.printInfo("Validating file '" + this.source + "'");
        if (!this.failOn.isEmpty()) {
            this.getLog().info((CharSequence)("Will fail build on errors of severity: " + this.failOn.stream().map(Enum::name).collect(Collectors.joining(", "))));
        } else {
            this.getLog().warn((CharSequence)("No errors will fail the build, reporting only. Adjust 'failOn' property to fail on requested severities:" + Arrays.toString(Severity.values())));
        }
        this.printErrorDescriptionsWithLink(zallyRunner.getRules());
        this.printSkippedRulesInfo(zallyRunner.getRules());
        Map<CheckDetails, List<Result>> results = this.validate(zallyRunner, this.skipRules, this.source);
        LinkedHashMap<Severity, Map<CheckDetails, List<Result>>> resultsBySeverity = new LinkedHashMap<Severity, Map<CheckDetails, List<Result>>>();
        results.forEach((details, resultList) -> {
            for (Result result : resultList) {
                resultsBySeverity.compute(result.getViolationType(), (severity, resultsByDetail) -> {
                    if (resultsByDetail == null) {
                        resultsByDetail = new LinkedHashMap<CheckDetails, List>();
                    }
                    resultsByDetail.compute(details, (cd, rs) -> {
                        if (rs == null) {
                            rs = new LinkedList<Result>();
                        }
                        rs.add(result);
                        return rs;
                    });
                    return resultsByDetail;
                });
            }
        });
        this.printErrors(resultsBySeverity);
        this.writeResults(results);
        for (Severity severity : this.failOn) {
            int size = Optional.ofNullable((Map)resultsBySeverity.get(severity)).map(Map::size).orElse(0);
            if (size <= 0) continue;
            throw new MojoFailureException("Failing build due to errors with severity " + severity);
        }
    }

    private void printInfo(String message) {
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)message);
    }

    private void printErrors(Map<Severity, Map<CheckDetails, List<Result>>> results) {
        LinkedList violations = new LinkedList();
        results.forEach((severity, res) -> res.forEach((checkDetails, resultList) -> resultList.forEach(result -> violations.add(checkDetails.getRule().id() + " - " + severity + " - " + checkDetails.getInstance().getClass().getSimpleName() + " - " + result.getDescription() + " - " + result.getPointer()))));
        this.printHeader("Rule violations (" + violations.size() + ")");
        violations.forEach(v -> this.getLog().warn((CharSequence)v));
        this.getLog().warn((CharSequence)"");
    }

    private void printHeader(String message) {
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)message);
        this.getLog().info((CharSequence)StringUtils.repeat((String)"-", (int)message.length()));
    }

    private Config parseConfigMap(Map<String, String> ruleConfig) {
        TreeMap m = ruleConfig != null ? ruleConfig : new TreeMap();
        LinkedHashMap configurations = new LinkedHashMap();
        for (Map.Entry e : m.entrySet()) {
            Map<String, Object> config = this.loadConfig((String)e.getKey(), (String)e.getValue());
            Optional.ofNullable(config).ifPresent(c -> configurations.put((String)e.getKey(), c));
        }
        return ConfigFactory.parseMap(configurations);
    }

    private void printErrorDescriptionsWithLink(List<RuleDetails> rules) {
        List<String> errorDescriptionsWithLink = rules.stream().map(rule -> rule.getRule().id() + " - " + rule.getInstance().getClass().getSimpleName() + " - " + rule.getRule().severity().name() + " - " + rule.getRule().title() + " - " + rule.getRuleSet().getUrl()).sorted().collect(Collectors.toList());
        this.printHeader("Rules (" + rules.size() + ")");
        errorDescriptionsWithLink.forEach(i -> this.getLog().info((CharSequence)i));
    }

    private void printSkippedRulesInfo(List<RuleDetails> rules) {
        LinkedHashSet skipped = new LinkedHashSet();
        this.skipRules.forEach(ruleName -> {
            if (rules.stream().anyMatch(r -> {
                String ruleClassName = r.getInstance().getClass().getSimpleName();
                boolean ruleNameMatch = ruleClassName.equals(ruleName);
                boolean isSkipped = this.skipRules.contains(ruleClassName);
                return ruleNameMatch && isSkipped;
            })) {
                skipped.add(ruleName);
            } else {
                this.getLog().warn((CharSequence)("Requested to skip rule '" + ruleName + "', but no such rule is known."));
            }
        });
        List<String> skippedDescription = rules.stream().filter(r -> skipped.contains(r.getInstance().getClass().getSimpleName())).sorted(Comparator.comparing(a -> a.getRule().id())).map(d -> d.getRule().id() + " - " + d.getInstance().getClass().getSimpleName() + " - " + d.getRule().severity() + " - " + d.getRule().title()).collect(Collectors.toList());
        if (!skippedDescription.isEmpty()) {
            this.printHeader("Skipped rules (" + skippedDescription.size() + ")");
            skippedDescription.forEach(i -> this.getLog().info((CharSequence)i));
        }
    }

    private Map<String, Object> loadConfig(String ruleName, String ruleConfig) {
        try {
            return (Map)this.mapper.readValue(ruleConfig, Map.class);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException("Unable to parse configuration for rule name " + ruleName, (IOException)((Object)e));
        }
    }

    private void writeResults(Map<CheckDetails, List<Result>> results) {
        if (this.resultFile != null && !this.resultFile.trim().equals("")) {
            try {
                this.printInfo("Writing result file to " + this.resultFile);
                this.getLog().info((CharSequence)"");
                Path target = Paths.get(this.resultFile, new String[0]);
                Files.createDirectories(target.getParent(), new FileAttribute[0]);
                Files.writeString(target, (CharSequence)this.mapper.writeValueAsString(results.values().stream().filter(r -> !r.isEmpty()).collect(Collectors.toList())), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private Map<CheckDetails, List<Result>> validate(ZallyRunner zallyRunner, Set<String> skipped, String url) {
        try {
            return zallyRunner.validate(url, skipped);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e.getMessage(), e);
        }
    }
}

