/*
 * Decompiled with CFR 0.152.
 */
package com.ethlo.zally;

import com.ethlo.zally.ExtractionDefinition;
import com.ethlo.zally.OpenApiParser;
import com.ethlo.zally.OperationData;
import com.ethlo.zally.OperationFilter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import io.swagger.v3.core.filter.AbstractSpecFilter;
import io.swagger.v3.core.filter.OpenAPISpecFilter;
import io.swagger.v3.core.filter.SpecFilter;
import io.swagger.v3.core.model.ApiDescription;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(threadSafe=true, name="extract", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class ExtractMojo
extends AbstractMojo {
    @Parameter(required=true, defaultValue="${project.basedir}/src/main/resources/api.yaml", property="zally.source")
    private String source;
    @Parameter(property="outputFile")
    private File outputFile;
    @Parameter(property="configFile")
    private File configFile;
    @Parameter(property="skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="filters")
    private List<OperationFilter> filters;
    @Parameter(property="description")
    private String description;
    @Parameter(property="name")
    private String name;
    @Parameter(property="title")
    private String title;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${mojoExecution}", readonly=true, required=true)
    private MojoExecution mojoExecution;
    private static final ObjectMapper yamlMapper = new ObjectMapper((JsonFactory)new YAMLFactory().enable(YAMLGenerator.Feature.MINIMIZE_QUOTES).enable(YAMLGenerator.Feature.SPLIT_LINES).enable(YAMLGenerator.Feature.ALWAYS_QUOTE_NUMBERS_AS_STRINGS)).setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
    private static final ObjectMapper mapper = new ObjectMapper();

    public void execute() throws MojoFailureException {
        Optional<OpenAPI> loaded = ExtractMojo.load(this.getLog(), this.skip, this.source, false);
        if (this.name == null) {
            this.name = this.mojoExecution.getExecutionId();
        }
        if (this.outputFile == null) {
            this.outputFile = Paths.get(this.project.getBuild().getOutputDirectory(), new String[0]).resolve(this.name + ".yaml").toFile();
        }
        if (this.configFile != null) {
            try {
                ExtractionDefinition extractionDefinition = (ExtractionDefinition)yamlMapper.readValue(this.configFile, ExtractionDefinition.class);
                if (this.title == null) {
                    this.title = extractionDefinition.getTitle();
                }
                if (this.description == null) {
                    this.description = extractionDefinition.getDescription();
                }
                this.filters = extractionDefinition.getFilters();
            }
            catch (IOException exc) {
                throw new UncheckedIOException(exc);
            }
        }
        loaded.ifPresent(openAPI -> {
            this.getLog().info((CharSequence)String.format("Processing extraction %s", this.name));
            AtomicInteger totalEvaluated = new AtomicInteger(0);
            AtomicInteger totalMatched = new AtomicInteger(0);
            OpenAPI filtered = new SpecFilter().filter(openAPI, (OpenAPISpecFilter)new AbstractSpecFilter((OpenAPI)openAPI, totalMatched, totalEvaluated){
                final /* synthetic */ OpenAPI val$openAPI;
                final /* synthetic */ AtomicInteger val$totalMatched;
                final /* synthetic */ AtomicInteger val$totalEvaluated;
                {
                    this.val$openAPI = openAPI;
                    this.val$totalMatched = atomicInteger;
                    this.val$totalEvaluated = atomicInteger2;
                }

                public Optional<Operation> filterOperation(Operation operation, ApiDescription api, Map<String, List<String>> params, Map<String, String> cookies, Map<String, List<String>> headers) {
                    String path = api.getPath();
                    PathItem pathItem = (PathItem)this.val$openAPI.getPaths().get((Object)path);
                    LinkedHashMap<String, Object> extensionMap = new LinkedHashMap<String, Object>(Optional.ofNullable(pathItem.getExtensions()).orElse(Collections.emptyMap()));
                    extensionMap.putAll(operation.getExtensions());
                    OperationData operationData = new OperationData(operation, api, extensionMap);
                    if (ExtractMojo.this.filters.stream().anyMatch(filter -> {
                        boolean matched = ExtractMojo.match(filter, operationData);
                        if (matched) {
                            this.val$totalMatched.incrementAndGet();
                            ExtractMojo.this.getLog().info((CharSequence)String.format("Including '%s' in '%s' because '%s'", operation.getOperationId(), ExtractMojo.this.name, filter.asString()));
                        }
                        this.val$totalEvaluated.incrementAndGet();
                        return matched;
                    })) {
                        return Optional.of(operation);
                    }
                    return Optional.empty();
                }

                public boolean isRemovingUnreferencedDefinitions() {
                    return true;
                }
            }, null, null, null);
            Optional.ofNullable(this.title).ifPresent(t -> filtered.getInfo().setTitle(t));
            Optional.ofNullable(this.description).ifPresent(t -> filtered.getInfo().setDescription(t));
            this.getLog().info((CharSequence)String.format("Included %s/%s API operations in extract", totalMatched.get(), totalEvaluated.get()));
            try {
                this.getLog().info((CharSequence)("Writing extracted APIs to " + this.outputFile));
                Files.createDirectories(this.outputFile.toPath().getParent(), new FileAttribute[0]);
                Yaml.mapper().writeValue(this.outputFile, (Object)filtered);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    public static boolean match(OperationFilter filter, OperationData data) {
        Object path = filter.getPointer().startsWith("/") ? filter.getPointer() : "/" + filter.getPointer();
        String regexp = filter.getExpression();
        try {
            JsonNode jsonNode = mapper.readTree(mapper.writeValueAsString((Object)data));
            JsonNode value = jsonNode.at(JsonPointer.compile((String)path));
            if (value.isObject()) {
                Iterator fieldNames = value.fieldNames();
                while (fieldNames.hasNext()) {
                    if (!filter.isMatch((String)fieldNames.next())) continue;
                    return true;
                }
            } else if (value.isArray()) {
                Iterator elements = value.elements();
                while (elements.hasNext()) {
                    if (!filter.isMatch(((JsonNode)elements.next()).textValue())) continue;
                    return true;
                }
            } else if (value.isTextual()) {
                return filter.isMatch(value.textValue());
            }
            return false;
        }
        catch (IOException exc) {
            throw new UncheckedIOException(exc);
        }
    }

    public static Optional<OpenAPI> load(Log log, boolean skip, String source, boolean inlined) throws MojoFailureException {
        if (skip) {
            log.info((CharSequence)"Skipping execution as requested");
            return Optional.empty();
        }
        boolean existsOnClassPath = ExtractMojo.class.getClassLoader().getResourceAsStream(source) != null;
        boolean existsOnFilesystem = Files.exists(Paths.get(source, new String[0]), new LinkOption[0]);
        if (!existsOnClassPath && !existsOnFilesystem) {
            throw new MojoFailureException("The specified source file could not be found: " + source);
        }
        log.info((CharSequence)("Reading file '" + source + "'"));
        return Optional.of(inlined ? new OpenApiParser().parseInlined(source) : new OpenApiParser().parse(source));
    }
}

