/*
 * Decompiled with CFR 0.152.
 */
package com.ethlo.zally;

import com.ethlo.zally.ApiReporter;
import com.ethlo.zally.ExtractMojo;
import com.ethlo.zally.OpenApiParser;
import io.swagger.v3.oas.models.OpenAPI;
import java.util.Arrays;
import java.util.Optional;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(threadSafe=true, name="report", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class ReportingMojo
extends AbstractMojo {
    @Parameter(required=true, defaultValue="${project.basedir}/src/main/resources/api.yaml", property="zally.source")
    private String source;
    @Parameter(property="zally.skip", defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;

    public void execute() throws MojoFailureException {
        Optional<OpenAPI> loaded = ExtractMojo.load(this.getLog(), this.skip, this.source, true);
        loaded.ifPresent(openAPI -> {
            this.getLog().info((CharSequence)("Analyzing file '" + this.source + "'"));
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)"API path hierarchy:");
            String hierarchy = new ApiReporter(new OpenApiParser().parseInlined(this.source)).render();
            Arrays.stream(hierarchy.split("\n")).forEach(line -> this.getLog().info((CharSequence)line));
            this.getLog().info((CharSequence)"");
        });
    }
}

