/*
 * Decompiled with CFR 0.152.
 */
package com.ethlo.zally;

import com.google.common.collect.Iterators;
import io.swagger.models.Method;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public class ApiReporter {
    private final OpenAPI openAPI;

    public ApiReporter(OpenAPI openAPI) {
        this.openAPI = openAPI;
    }

    private Map<Method, Operation> getOperations(PathItem value) {
        LinkedHashMap<Method, Operation> operations = new LinkedHashMap<Method, Operation>();
        operations.put(Method.GET, value.getGet());
        operations.put(Method.PUT, value.getPut());
        operations.put(Method.DELETE, value.getDelete());
        operations.put(Method.HEAD, value.getHead());
        operations.put(Method.OPTIONS, value.getOptions());
        operations.put(Method.POST, value.getPost());
        operations.put(Method.PATCH, value.getPatch());
        operations.values().removeIf(Objects::isNull);
        return operations;
    }

    public String render() {
        Paths paths = this.openAPI.getPaths();
        Node root = new Node("");
        for (Map.Entry pathEntry : paths.entrySet()) {
            Map<Method, Operation> methodOperations = this.getOperations((PathItem)pathEntry.getValue());
            for (Map.Entry<Method, Operation> methodOperationEntry : methodOperations.entrySet()) {
                root.addPath((String)pathEntry.getKey(), methodOperationEntry.getKey(), methodOperationEntry.getValue().getOperationId());
            }
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.printTree(root, bout);
        return bout.toString(StandardCharsets.UTF_8);
    }

    private void print(String prefix, Node node, boolean isTail, boolean isRoot, PrintWriter out) {
        String strConnector = isRoot ? "" : (isTail ? "\u2514\u2500\u2500 " : "\u251c\u2500\u2500 ");
        String strNode = node.item;
        out.println(prefix + strConnector + strNode);
        Set<Node> children = node.getChildren();
        if (!children.isEmpty()) {
            children.stream().limit(children.size() - 1).forEach(child -> this.print(prefix + (isTail ? "    " : "\u2502   "), (Node)child, false, false, out));
            this.print(prefix + (isTail ? "    " : "\u2502   "), (Node)Iterators.getLast(children.iterator()), true, false, out);
        }
        out.flush();
    }

    public void printTree(Node ref, OutputStream out) {
        PrintWriter pw = new PrintWriter(out);
        Set<Node> roots = ref.getChildren();
        if (roots == null) {
            pw.println(ref + " does not exist");
            pw.flush();
            return;
        }
        if (roots.isEmpty()) {
            pw.flush();
            return;
        }
        this.print("", ref, true, true, pw);
    }

    static class Node {
        private final String item;
        private final Set<Node> children = new LinkedHashSet<Node>();

        public Node(String item) {
            this.item = Objects.requireNonNull(item, "item cannot be null");
        }

        public String getItem() {
            return this.item;
        }

        public Set<Node> getChildren() {
            return this.children;
        }

        public void addPath(String pathUri, Method method, String operationId) {
            AtomicReference<Node> nodeRef = new AtomicReference<Node>(this);
            Arrays.stream(pathUri.split("/")).filter(p -> !p.isEmpty()).forEach(pathPart -> {
                Node newNode = ((Node)nodeRef.get()).getOrCreateNode((String)pathPart);
                ((Node)nodeRef.get()).children.add(newNode);
                nodeRef.set(newNode);
            });
            nodeRef.get().children.add(new Node(method.name() + " - " + operationId));
        }

        private Node getOrCreateNode(String item) {
            for (Node child : this.children) {
                if (!child.getItem().equals(item)) continue;
                return child;
            }
            return new Node(item);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Node node = (Node)o;
            return Objects.equals(this.item, node.item);
        }

        public int hashCode() {
            return Objects.hash(this.item);
        }

        public String toString() {
            return "Node{item='" + this.item + "', children=" + this.children.size() + "}";
        }
    }
}

