/*
 * Decompiled with CFR 0.152.
 */
package com.ethlo.zally;

import com.ethlo.zally.OpenApiParser;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.plugin.logging.Log;
import org.jetbrains.annotations.NotNull;
import org.zalando.zally.core.CheckDetails;
import org.zalando.zally.core.DefaultContext;
import org.zalando.zally.core.JsonPointerLocator;
import org.zalando.zally.core.Result;
import org.zalando.zally.core.RuleDetails;
import org.zalando.zally.rule.api.Check;
import org.zalando.zally.rule.api.Context;
import org.zalando.zally.rule.api.Rule;
import org.zalando.zally.rule.api.RuleSet;
import org.zalando.zally.rule.api.Violation;

public class ZallyRunner {
    private final List<RuleDetails> rules = new LinkedList<RuleDetails>();
    private final Log logger;

    public ZallyRunner(Config ruleConfigs, Log logger) {
        this.logger = logger;
        List<Class<?>> ruleClasses = this.loadRuleClasses();
        for (Class<?> ruleClass : ruleClasses) {
            String simpleName = ruleClass.getSimpleName();
            logger.debug((CharSequence)("Loading rule " + simpleName));
            Object instance = this.createRuleInstance(ruleClass, ruleConfigs);
            Rule ruleAnnotation = ruleClass.getAnnotation(Rule.class);
            this.rules.add(new RuleDetails((RuleSet)this.createInstance(ruleAnnotation.ruleSet()), ruleAnnotation, instance));
        }
    }

    public Map<CheckDetails, List<Result>> validate(String url, Set<String> skipped) throws IOException {
        OpenAPI openApi = new OpenApiParser().parseInlined(url);
        DefaultContext context = new DefaultContext("", openApi, null);
        LinkedHashMap<CheckDetails, List<Result>> returnValue = new LinkedHashMap<CheckDetails, List<Result>>();
        for (RuleDetails ruleDetails : this.rules) {
            if (skipped.contains(ruleDetails.getInstance().getClass().getSimpleName())) continue;
            Object instance = ruleDetails.getInstance();
            for (Method method : instance.getClass().getDeclaredMethods()) {
                Check checkAnnotation = method.getAnnotation(Check.class);
                if (checkAnnotation == null || method.getParameterTypes().length != 1 || method.getParameterTypes()[0] != Context.class) continue;
                ArrayList<Result> violationList = new ArrayList<Result>();
                CheckDetails checkDetails = this.performCheck((Context)context, violationList, instance, ruleDetails.getRule(), ruleDetails.getRuleSet(), method, checkAnnotation, url);
                returnValue.put(checkDetails, violationList);
            }
        }
        return returnValue;
    }

    @NotNull
    private CheckDetails performCheck(Context context, List<Result> violationList, Object instance, Rule ruleAnnotation, RuleSet ruleSet, Method method, Check checkAnnotation, String url) {
        Object result;
        CheckDetails checkDetails = new CheckDetails(ruleSet, ruleAnnotation, instance, checkAnnotation, method);
        try {
            result = method.invoke(instance, context);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        if (result != null) {
            if (result instanceof Iterable) {
                for (Violation violation : (Iterable)result) {
                    if (context.isIgnored(violation.getPointer(), checkDetails.getRule().id()) || context.isIgnored(violation.getPointer(), "*")) {
                        this.logger.info((CharSequence)String.format("Ignore violation, rule = %s, at %s", checkDetails.getRule().id(), violation.getPointer()));
                        continue;
                    }
                    violationList.add(this.handleViolation(url, checkDetails, violation));
                }
            } else if (result instanceof Violation) {
                violationList.add(this.handleViolation(url, checkDetails, (Violation)result));
            }
        }
        return checkDetails;
    }

    private List<Class<?>> loadRuleClasses() {
        try (ScanResult result = new ClassGraph().enableClassInfo().enableAnnotationInfo().scan();){
            ClassInfoList classInfos = result.getClassesWithAnnotation(Rule.class.getName());
            List<Class<?>> list = classInfos.stream().map(ClassInfo::loadClass).collect(Collectors.toList());
            return list;
        }
    }

    private Object createRuleInstance(Class<?> ruleClass, Config ruleConfig) {
        try {
            for (Constructor<?> constructor : ruleClass.getConstructors()) {
                Class<?>[] paramTypes = constructor.getParameterTypes();
                if (paramTypes.length != 1 || !paramTypes[0].equals(Config.class)) continue;
                return constructor.newInstance(ruleConfig.withFallback((ConfigMergeable)ConfigFactory.parseMap(Collections.emptyMap())));
            }
            return ruleClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Cannot instantiate rule " + ruleClass, e);
        }
    }

    private Object createInstance(Class<?> type) {
        try {
            Constructor<?> constructor = type.getConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Cannot instantiate class " + type, e);
        }
    }

    private Result handleViolation(String url, CheckDetails details, Violation violation) {
        JsonPointerLocator locator = new JsonPointerLocator("");
        try {
            locator = new JsonPointerLocator(Files.readString(Paths.get(url, new String[0])));
        }
        catch (IOException e) {
            this.logger.warn((CharSequence)"Could not read File");
            e.printStackTrace();
        }
        return new Result(details.getRule().id(), details.getRuleSet().url(details.getRule()), details.getRule().title(), violation.getDescription(), details.getCheck().severity(), violation.getPointer(), locator.locate(violation.getPointer()));
    }

    public List<RuleDetails> getRules() {
        return this.rules;
    }
}

