/*
 * Decompiled with CFR 0.152.
 */
package com.ethlo.zally.rules;

import com.ethlo.zally.rules.ConfigurableZalandoRuleSet;
import com.ethlo.zally.rules.common.PlingStemmer;
import com.typesafe.config.Config;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.Schema;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.zalando.zally.rule.api.Check;
import org.zalando.zally.rule.api.Context;
import org.zalando.zally.rule.api.Rule;
import org.zalando.zally.rule.api.Severity;
import org.zalando.zally.rule.api.Violation;

@Rule(ruleSet=ConfigurableZalandoRuleSet.class, id="120", severity=Severity.SHOULD, title="Array names should be pluralized")
public class WhiteListedPluralizeNamesForArraysRule {
    private final List<String> whiteList;

    public WhiteListedPluralizeNamesForArraysRule(Config config) {
        this.whiteList = config.hasPath(this.getClass().getSimpleName()) ? config.getConfig(this.getClass().getSimpleName()).getStringList("whitelist") : Collections.emptyList();
    }

    public static Map<String, Schema> getAllSchemas(OpenAPI openAPI) {
        if (openAPI != null && openAPI.getComponents() != null && openAPI.getComponents().getSchemas() != null) {
            return openAPI.getComponents().getSchemas();
        }
        return Collections.emptyMap();
    }

    @Check(severity=Severity.SHOULD)
    public List<Violation> checkArrayPropertyNamesArePlural(Context context) {
        return WhiteListedPluralizeNamesForArraysRule.getAllSchemas(context.getApi()).entrySet().stream().filter(it -> "array".equals(((Schema)it.getValue()).getType())).filter(it -> this.whiteList.contains(it.getKey())).filter(it -> !PlingStemmer.isPlural((String)it.getKey())).map(it -> context.violation("Array property name appears to be singular: " + (String)it.getKey(), it.getValue())).collect(Collectors.toList());
    }
}

