/*
 * Decompiled with CFR 0.152.
 */
package com.evanlennick.retry4j.config;

import com.evanlennick.retry4j.backoff.BackoffStrategy;
import java.time.Duration;
import java.util.HashSet;
import java.util.Set;

public class RetryConfig {
    private Boolean retryOnAnyException = false;
    private Set<Class<? extends Exception>> retryOnSpecificExceptions = new HashSet<Class<? extends Exception>>();
    private Set<Class<? extends Exception>> retryOnAnyExceptionExcluding = new HashSet<Class<? extends Exception>>();
    private Integer maxNumberOfTries;
    private Duration delayBetweenRetries;
    private BackoffStrategy backoffStrategy;
    private Object valueToRetryOn;
    private Boolean retryOnValue = false;

    public Object getValueToRetryOn() {
        return this.valueToRetryOn;
    }

    public void setValueToRetryOn(Object valueToRetryOn) {
        this.valueToRetryOn = valueToRetryOn;
    }

    public Boolean shouldRetryOnValue() {
        return this.retryOnValue;
    }

    public void setRetryOnValue(Boolean retryOnValue) {
        this.retryOnValue = retryOnValue;
    }

    public Boolean isRetryOnAnyException() {
        return this.retryOnAnyException;
    }

    public void setRetryOnAnyException(boolean retryOnAnyException) {
        this.retryOnAnyException = retryOnAnyException;
    }

    public Set<Class<? extends Exception>> getRetryOnSpecificExceptions() {
        return this.retryOnSpecificExceptions;
    }

    public void setRetryOnSpecificExceptions(Set<Class<? extends Exception>> retryOnSpecificExceptions) {
        this.retryOnSpecificExceptions = retryOnSpecificExceptions;
    }

    public Set<Class<? extends Exception>> getRetryOnAnyExceptionExcluding() {
        return this.retryOnAnyExceptionExcluding;
    }

    public void setRetryOnAnyExceptionExcluding(Set<Class<? extends Exception>> retryOnAnyExceptionExcluding) {
        this.retryOnAnyExceptionExcluding = retryOnAnyExceptionExcluding;
    }

    public Integer getMaxNumberOfTries() {
        return this.maxNumberOfTries;
    }

    public void setMaxNumberOfTries(int maxNumberOfTries) {
        if (maxNumberOfTries < 0) {
            throw new IllegalArgumentException("Must be a non-negative number.");
        }
        this.maxNumberOfTries = maxNumberOfTries;
    }

    public Duration getDelayBetweenRetries() {
        return this.delayBetweenRetries;
    }

    public void setDelayBetweenRetries(Duration delayBetweenRetries) {
        if (delayBetweenRetries.isNegative()) {
            throw new IllegalArgumentException("Must be a non-negative Duration.");
        }
        this.delayBetweenRetries = delayBetweenRetries;
    }

    public BackoffStrategy getBackoffStrategy() {
        return this.backoffStrategy;
    }

    public void setBackoffStrategy(BackoffStrategy backoffStrategy) {
        this.backoffStrategy = backoffStrategy;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RetryConfig{");
        sb.append("retryOnAnyException=").append(this.retryOnAnyException);
        sb.append(", retryOnSpecificExceptions=").append(this.retryOnSpecificExceptions);
        sb.append(", maxNumberOfTries=").append(this.maxNumberOfTries);
        sb.append(", delayBetweenRetries=").append(this.delayBetweenRetries);
        sb.append(", backoffStrategy=").append(this.backoffStrategy);
        sb.append('}');
        return sb.toString();
    }
}

