/*
 * Decompiled with CFR 0.152.
 */
package com.evanlennick.retry4j.config;

import com.evanlennick.retry4j.backoff.BackoffStrategy;
import com.evanlennick.retry4j.backoff.ExponentialBackoffStrategy;
import com.evanlennick.retry4j.backoff.FibonacciBackoffStrategy;
import com.evanlennick.retry4j.backoff.FixedBackoffStrategy;
import com.evanlennick.retry4j.backoff.NoWaitBackoffStrategy;
import com.evanlennick.retry4j.backoff.RandomBackoffStrategy;
import com.evanlennick.retry4j.backoff.RandomExponentialBackoffStrategy;
import com.evanlennick.retry4j.config.RetryConfig;
import com.evanlennick.retry4j.exception.InvalidRetryConfigException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.HashSet;

public class RetryConfigBuilder {
    private boolean exceptionStrategySpecified = false;
    private RetryConfig config = new RetryConfig();
    private boolean validationEnabled = true;
    public static final String MUST_SPECIFY_BACKOFF__ERROR_MSG = "Retry config must specify a backoff strategy!";
    public static final String MUST_SPECIFY_MAX_TRIES__ERROR_MSG = "Retry config must specify a maximum number of tries!";
    public static final String CAN_ONLY_SPECIFY_ONE_BACKOFF_STRAT__ERROR_MSG = "Retry config cannot specify more than one backoff strategy!";
    public static final String CAN_ONLY_SPECIFY_ONE_EXCEPTION_STRAT__ERROR_MSG = "Retry config cannot specify more than one exception strategy!";
    public static final String ALREADY_SPECIFIED_NUMBER_OF_TRIES__ERROR_MSG = "Number of tries can only be specified once!";

    public RetryConfigBuilder() {
    }

    public RetryConfigBuilder(boolean validationEnabled) {
        this();
        this.validationEnabled = validationEnabled;
    }

    public boolean isValidationEnabled() {
        return this.validationEnabled;
    }

    public void setValidationEnabled(boolean validationEnabled) {
        this.validationEnabled = validationEnabled;
    }

    public RetryConfigBuilder retryOnAnyException() {
        this.validateExceptionStrategyAddition();
        this.config.setRetryOnAnyException(true);
        this.exceptionStrategySpecified = true;
        return this;
    }

    public RetryConfigBuilder failOnAnyException() {
        this.validateExceptionStrategyAddition();
        this.config.setRetryOnAnyException(false);
        this.config.setRetryOnSpecificExceptions(new HashSet<Class<? extends Exception>>());
        this.exceptionStrategySpecified = true;
        return this;
    }

    @SafeVarargs
    public final RetryConfigBuilder retryOnSpecificExceptions(Class<? extends Exception> ... exceptions) {
        this.validateExceptionStrategyAddition();
        HashSet<Class<? extends Exception>> setOfExceptions = new HashSet<Class<? extends Exception>>(Arrays.asList(exceptions));
        this.config.setRetryOnSpecificExceptions(setOfExceptions);
        this.exceptionStrategySpecified = true;
        return this;
    }

    @SafeVarargs
    public final RetryConfigBuilder retryOnAnyExceptionExcluding(Class<? extends Exception> ... exceptions) {
        this.validateExceptionStrategyAddition();
        HashSet<Class<? extends Exception>> setOfExceptions = new HashSet<Class<? extends Exception>>(Arrays.asList(exceptions));
        this.config.setRetryOnAnyExceptionExcluding(setOfExceptions);
        this.exceptionStrategySpecified = true;
        return this;
    }

    public final RetryConfigBuilder retryOnReturnValue(Object value) {
        this.config.setRetryOnValue(true);
        this.config.setValueToRetryOn(value);
        return this;
    }

    public RetryConfigBuilder withMaxNumberOfTries(int max) {
        if (this.config.getMaxNumberOfTries() != null) {
            throw new InvalidRetryConfigException(ALREADY_SPECIFIED_NUMBER_OF_TRIES__ERROR_MSG);
        }
        this.config.setMaxNumberOfTries(max);
        return this;
    }

    public RetryConfigBuilder retryIndefinitely() {
        if (this.config.getMaxNumberOfTries() != null) {
            throw new InvalidRetryConfigException(ALREADY_SPECIFIED_NUMBER_OF_TRIES__ERROR_MSG);
        }
        this.config.setMaxNumberOfTries(Integer.MAX_VALUE);
        return this;
    }

    public RetryConfigBuilder withDelayBetweenTries(Duration duration) {
        this.config.setDelayBetweenRetries(duration);
        return this;
    }

    public RetryConfigBuilder withDelayBetweenTries(long amount, ChronoUnit time) {
        this.config.setDelayBetweenRetries(Duration.of(amount, time));
        return this;
    }

    public RetryConfigBuilder withBackoffStrategy(BackoffStrategy backoffStrategy) {
        this.validateBackoffStrategyAddition();
        this.config.setBackoffStrategy(backoffStrategy);
        return this;
    }

    public RetryConfigBuilder withFixedBackoff() {
        this.validateBackoffStrategyAddition();
        this.config.setBackoffStrategy(new FixedBackoffStrategy());
        return this;
    }

    public RetryConfigBuilder withExponentialBackoff() {
        this.validateBackoffStrategyAddition();
        this.config.setBackoffStrategy(new ExponentialBackoffStrategy());
        return this;
    }

    public RetryConfigBuilder withFibonacciBackoff() {
        this.validateBackoffStrategyAddition();
        this.config.setBackoffStrategy(new FibonacciBackoffStrategy());
        return this;
    }

    public RetryConfigBuilder withNoWaitBackoff() {
        this.validateBackoffStrategyAddition();
        this.config.setBackoffStrategy(new NoWaitBackoffStrategy());
        return this;
    }

    public RetryConfigBuilder withRandomBackoff() {
        this.validateBackoffStrategyAddition();
        this.config.setBackoffStrategy(new RandomBackoffStrategy());
        return this;
    }

    public RetryConfigBuilder withRandomExponentialBackoff() {
        this.validateBackoffStrategyAddition();
        this.config.setBackoffStrategy(new RandomExponentialBackoffStrategy());
        return this;
    }

    public RetryConfig build() {
        this.validateConfig();
        return this.config;
    }

    private void validateConfig() {
        if (!this.validationEnabled) {
            return;
        }
        if (null == this.config.getBackoffStrategy()) {
            throw new InvalidRetryConfigException(MUST_SPECIFY_BACKOFF__ERROR_MSG);
        }
        if (null == this.config.getMaxNumberOfTries()) {
            throw new InvalidRetryConfigException(MUST_SPECIFY_MAX_TRIES__ERROR_MSG);
        }
        this.config.getBackoffStrategy().validateConfig(this.config);
    }

    private void validateBackoffStrategyAddition() {
        if (!this.validationEnabled) {
            return;
        }
        if (null != this.config.getBackoffStrategy()) {
            throw new InvalidRetryConfigException(CAN_ONLY_SPECIFY_ONE_BACKOFF_STRAT__ERROR_MSG);
        }
    }

    private void validateExceptionStrategyAddition() {
        if (!this.validationEnabled) {
            return;
        }
        if (this.exceptionStrategySpecified) {
            throw new InvalidRetryConfigException(CAN_ONLY_SPECIFY_ONE_EXCEPTION_STRAT__ERROR_MSG);
        }
    }

    public RetryConfigBuilder fixedBackoff5Tries10Sec() {
        return new RetryConfigBuilder().retryOnAnyException().withMaxNumberOfTries(5).withDelayBetweenTries(10L, ChronoUnit.SECONDS).withFixedBackoff();
    }

    public RetryConfigBuilder exponentialBackoff5Tries5Sec() {
        return new RetryConfigBuilder().retryOnAnyException().withMaxNumberOfTries(5).withDelayBetweenTries(5L, ChronoUnit.SECONDS).withExponentialBackoff();
    }

    public RetryConfigBuilder fiboBackoff7Tries5Sec() {
        return new RetryConfigBuilder().retryOnAnyException().withMaxNumberOfTries(7).withDelayBetweenTries(5L, ChronoUnit.SECONDS).withFibonacciBackoff();
    }

    public RetryConfigBuilder randomExpBackoff10Tries60Sec() {
        return new RetryConfigBuilder().retryOnAnyException().withMaxNumberOfTries(10).withDelayBetweenTries(60L, ChronoUnit.SECONDS).withRandomExponentialBackoff();
    }
}

