/*
 * Decompiled with CFR 0.152.
 */
package com.evanlennick.retry4j;

import com.evanlennick.retry4j.CallExecutor;
import com.evanlennick.retry4j.RetryExecutor;
import com.evanlennick.retry4j.Status;
import com.evanlennick.retry4j.config.RetryConfig;
import com.evanlennick.retry4j.listener.RetryListener;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;

public class AsyncCallExecutor<T>
implements RetryExecutor<T, CompletableFuture<Status<T>>> {
    private RetryConfig config;
    private ExecutorService executorService;
    private RetryListener afterFailedTryListener;
    private RetryListener beforeNextTryListener;
    private RetryListener onFailureListener;
    private RetryListener onSuccessListener;
    private RetryListener onCompletionListener;

    public AsyncCallExecutor(RetryConfig config) {
        this(config, null);
    }

    public AsyncCallExecutor(RetryConfig config, ExecutorService executorService) {
        this.config = config;
        this.executorService = executorService;
    }

    @Override
    public CompletableFuture<Status<T>> execute(Callable<T> callable) {
        return this.execute((Callable)callable, (String)null);
    }

    @Override
    public CompletableFuture<Status<T>> execute(Callable<T> callable, String callName) {
        CallExecutor synchronousCallExecutor = new CallExecutor(this.config);
        synchronousCallExecutor.afterFailedTry(this.afterFailedTryListener);
        synchronousCallExecutor.beforeNextTry(this.beforeNextTryListener);
        synchronousCallExecutor.onSuccess(this.onSuccessListener);
        synchronousCallExecutor.onFailure(this.onFailureListener);
        synchronousCallExecutor.onCompletion(this.onCompletionListener);
        CompletableFuture<Status<T>> completableFuture = new CompletableFuture<Status<T>>();
        if (this.executorService != null) {
            this.executorService.submit(() -> this.executeFuture(callable, callName, synchronousCallExecutor, completableFuture));
        } else {
            new Thread(() -> this.executeFuture(callable, callName, synchronousCallExecutor, completableFuture)).start();
        }
        return completableFuture;
    }

    private void executeFuture(Callable<T> callable, String callName, CallExecutor<T> synchronousCallExecutor, CompletableFuture<Status<T>> completableFuture) {
        try {
            Object status = synchronousCallExecutor.execute((Callable)callable, callName);
            completableFuture.complete((Status<Object>)status);
        }
        catch (Throwable t) {
            completableFuture.completeExceptionally(t);
        }
    }

    public AsyncCallExecutor<T> afterFailedTry(RetryListener listener) {
        this.afterFailedTryListener = listener;
        return this;
    }

    public AsyncCallExecutor<T> beforeNextTry(RetryListener listener) {
        this.beforeNextTryListener = listener;
        return this;
    }

    public AsyncCallExecutor<T> onCompletion(RetryListener listener) {
        this.onCompletionListener = listener;
        return this;
    }

    public AsyncCallExecutor<T> onSuccess(RetryListener listener) {
        this.onSuccessListener = listener;
        return this;
    }

    public AsyncCallExecutor<T> onFailure(RetryListener listener) {
        this.onFailureListener = listener;
        return this;
    }

    @Override
    public void setConfig(RetryConfig config) {
        this.config = config;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Deprecated
    public ExecutorService getThreadExecutorService() {
        return this.executorService;
    }
}

