/*
 * Decompiled with CFR 0.152.
 */
package com.evanlennick.retry4j;

import com.evanlennick.retry4j.CallResults;
import com.evanlennick.retry4j.RetryConfig;
import com.evanlennick.retry4j.RetryConfigBuilder;
import com.evanlennick.retry4j.exception.RetriesExhaustedException;
import com.evanlennick.retry4j.exception.UnexpectedException;
import com.evanlennick.retry4j.listener.AfterFailedTryListener;
import com.evanlennick.retry4j.listener.BeforeNextTryListener;
import com.evanlennick.retry4j.listener.OnFailureListener;
import com.evanlennick.retry4j.listener.OnSuccessListener;
import com.evanlennick.retry4j.listener.RetryListener;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class CallExecutor {
    private RetryConfig config;
    private AfterFailedTryListener afterFailedTryListener;
    private BeforeNextTryListener beforeNextTryListener;
    private OnFailureListener onFailureListener;
    private OnSuccessListener onSuccessListener;
    private ExecutorService executorService;
    private CallResults<Object> results = new CallResults();

    public CallExecutor() {
        this(new RetryConfigBuilder().fixedBackoff5Tries10Sec().build());
    }

    public CallExecutor(RetryConfig config) {
        this.config = config;
    }

    public CallResults<Object> execute(Callable<?> callable) throws RetriesExhaustedException, UnexpectedException {
        int tries;
        long start = System.currentTimeMillis();
        this.results.setStartTime(start);
        int maxTries = this.config.getMaxNumberOfTries();
        long millisBetweenTries = this.config.getDelayBetweenRetries().toMillis();
        this.results.setCallName(callable.toString());
        Optional<Object> result = Optional.empty();
        for (tries = 0; tries < maxTries && !result.isPresent(); ++tries) {
            result = this.tryCall(callable);
            if (result.isPresent()) continue;
            this.handleRetry(millisBetweenTries, tries + 1);
        }
        this.refreshRetryResults(result.isPresent(), tries);
        this.results.setEndTime(System.currentTimeMillis());
        this.postExecutionCleanup(callable, maxTries, result);
        return this.results;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void postExecutionCleanup(Callable<?> callable, int maxTries, Optional<Object> result) {
        if (!result.isPresent()) {
            String failureMsg = String.format("Call '%s' failed after %d tries!", callable.toString(), maxTries);
            if (null == this.onFailureListener) throw new RetriesExhaustedException(failureMsg, this.results);
            this.onFailureListener.onFailure(this.results);
            return;
        } else {
            this.results.setResult(result.get());
            if (null == this.onSuccessListener) return;
            this.onSuccessListener.onSuccess(this.results);
        }
    }

    public void executeAsync(Callable<?> callable) {
        if (null == this.executorService) {
            this.executorService = Executors.newFixedThreadPool(10);
        }
        Runnable runnable = () -> this.execute(callable);
        this.executorService.execute(runnable);
    }

    private Optional<Object> tryCall(Callable<?> callable) throws UnexpectedException {
        try {
            Object result = callable.call();
            return Optional.of(result);
        }
        catch (Exception e) {
            if (this.shouldThrowException(e)) {
                throw new UnexpectedException(e);
            }
            return Optional.empty();
        }
    }

    private void handleRetry(long millisBetweenTries, int tries) {
        this.refreshRetryResults(false, tries);
        if (null != this.afterFailedTryListener) {
            this.afterFailedTryListener.immediatelyAfterFailedTry(this.results);
        }
        this.sleep(millisBetweenTries, tries);
        if (null != this.beforeNextTryListener) {
            this.beforeNextTryListener.immediatelyBeforeNextTry(this.results);
        }
    }

    private void refreshRetryResults(boolean success, int tries) {
        long currentTime = System.currentTimeMillis();
        long elapsed = currentTime - this.results.getStartTime();
        this.results.setTotalTries(tries);
        this.results.setTotalElapsedDuration(Duration.of(elapsed, ChronoUnit.MILLIS));
        this.results.setSuccessful(success);
    }

    private void sleep(long millis, int tries) {
        Duration duration = Duration.of(millis, ChronoUnit.MILLIS);
        long millisToSleep = this.config.getBackoffStrategy().getMillisToWait(tries, duration);
        try {
            TimeUnit.MILLISECONDS.sleep(millisToSleep);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean shouldThrowException(Exception e) {
        if (this.config.isRetryOnAnyException().booleanValue()) {
            return false;
        }
        for (Class<? extends Exception> exceptionInSet : this.config.getRetryOnSpecificExceptions()) {
            if (!e.getClass().isAssignableFrom(exceptionInSet)) continue;
            return false;
        }
        return true;
    }

    public void registerRetryListener(RetryListener listener) {
        if (listener instanceof AfterFailedTryListener) {
            this.afterFailedTryListener = (AfterFailedTryListener)listener;
        } else if (listener instanceof BeforeNextTryListener) {
            this.beforeNextTryListener = (BeforeNextTryListener)listener;
        } else if (listener instanceof OnSuccessListener) {
            this.onSuccessListener = (OnSuccessListener)listener;
        } else if (listener instanceof OnFailureListener) {
            this.onFailureListener = (OnFailureListener)listener;
        } else {
            throw new IllegalArgumentException("Tried to register an unrecognized RetryListener!");
        }
    }

    public void setConfig(RetryConfig config) {
        this.config = config;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }
}

